DESCRIPTION="The libxcb package provides an interface to the X Window System protocol, which replaces the current Xlib interface. Xlib can also use XCB as a transport layer, allowing software to make requests and receive responses with both."
# libxcb

# The libxcb package provides an interface to the X Window System protocol, which replaces the current Xlib interface. Xlib can also use XCB as a transport layer, allowing software to make requests and receive responses with both

# Contents
# Installed Programs: None
# Installed Libraries: libxcb.so, libxcb-composite.so, libxcb-damage.so, libxcb-dbe.so, libxcb-dpms.so, libxcb-dri2.so, libxcb-dri3.so, libxcb-glx.so, libxcb-present.so, libxcb-randr.so, libxcb-record.so, libxcb-render.so, libxcb-res.so, libxcb-screensaver.so, libxcb-shape.so, libxcb-shm.so, libxcb-sync.so, libxcb-xf86dri.so, libxcb-xfixes.so, libxcb-xinerama.so, libxcb-xinput.so, libxcb-xkb.so, libxcb-xtest.so, libxcb-xvmc.so, and libxcb-xv.so
# Installed Directories: $XORG_PREFIX/include/xcb and $XORG_PREFIX/share/doc/libxcb-1.17.0

# Short Descriptions
# libxcb.so - is an interface to the X Window System protocol

VERSION_EXT=$(basename $PKG_LIBXCB .tar.xz | cut -d "-" -f 2) 

[[ $(command -v doxygen) == "" ]] && OPTIONS="--without-doxygen"

./configure $XORG_CONFIG      \
            $OPTIONS \
            --docdir='${datadir}'/doc/libxcb-$VERSION_EXT
LC_ALL=en_US.UTF-8 make

# As root:
make install

if $MULTILIB
then
	make distclean 
	CC="gcc -m32" CXX="g++ -m32" 			\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig 	\
	./configure $XORG_CONFIG --libdir=/usr/lib32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure $XORG_CONFIG --libdir=/usr/libx32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

chown -Rv root:root $XORG_PREFIX/share/doc/libxcb-$VERSION_EXT

update_version_list $PKG_LIBXCB
