DESCRIPTION="The libwebp package contains a library and support programs to encode and decode images in WebP format."
# libwebp
# The libwebp package contains a library and support programs to encode and decode images in WebP format. 

# Contents
# Installed Programs: libsharpyuv.so, libwebpdecoder.so, libwebpdemux.so, libwebpmux.so, and libwebp.so
# Installed Libraries: libsharpyuv.so, libwebpdecoder.so, libwebpdemux.so, libwebpmux.so, and libwebp.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/webp

# Short Descriptions
# cwebp - compresses an image using the WebP format
# dwebp - decompresses WebP files into PNG, PAM, PPM or PGM images
# gif2webp - converts a GIF image to a WebP image
# img2webp - creates an animated WebP file from a sequence of input images
# vwebp - decompresses a WebP file and displays it in a window
# webpinfo - prints out the cunk level structure of WebP files along with performing basic integrity checks
# webpmux - creates animated WebP files from non-animated WebP images, extracts frames from animated WebP images, and manages XMP/EXIF metadata and the ICC profile
# libwebp.so - contains the API functions for WebP encoding and decoding

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBWEBP .tar.gz | cut -d "-" -f 2) 

./configure --prefix=/usr           \
            --enable-libwebpmux     \
            --enable-libwebpdemux   \
            --enable-libwebpdecoder \
            --enable-libwebpextras  \
            --enable-swap-16bit-csp \
            --disable-static        &&
make

# As root:
make install

update_version_list $PKG_LIBWEBP
