DESCRIPTION="The libvdpau-va-gl package contains a library which implements the VDPAU library."

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""

EXT_VERSION=$(basename $PKG_LIBVDPAU_VA_GL .tar.gz | cut -d "-" -f 4) 

mkdir build
cd    build

cmake -D CMAKE_INSTALL_PREFIX=$XORG_PREFIX \
      $OPTIONS							  \
      -D CMAKE_BUILD_TYPE=Release          \
      -W no-dev .. 
make

# As root:
make install

[[ $(cat /etc/profile.d/xorg.sh | grep "export VDPAU_DRIVER=va_gl") == "" ]] && echo "export VDPAU_DRIVER=va_gl" >> /etc/profile.d/xorg.sh

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	cmake -D CMAKE_BUILD_TYPE=Release         \
		  -D CMAKE_INSTALL_PREFIX=/usr        \
		  $OPTIONS -W no-dev ..
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"          \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	cmake -D CMAKE_BUILD_TYPE=Release         \
		  -D CMAKE_INSTALL_PREFIX=/usr        \
		  $OPTIONS -W no-dev ..
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBVDPAU_VA_GL
