DESCRIPTION="The libva package contains a library which provides access to hardware accelerated video processing"
# libva
# The libva package contains a library which provides access to hardware accelerated video processing, using hardware to accelerate video processing in order to offload the central processing unit (CPU) to decode and encode compressed digital video. The VA API video decode/encode interface is platform and window system independent targeted at Direct Rendering Infrastructure (DRI) in the X Window System however it can potentially also be used with direct framebuffer and graphics sub-systems for video output. Accelerated processing includes support for video decoding, video encoding, subpicture blending, and rendering.

# Contents
# Installed Programs: None
# Installed Libraries: libva-drm.so, libva-glx.so, libva.so, libva-wayland.so, and libva-x11.so
# Installed Directory: libva-drm.so, libva-glx.so, libva.so, libva-wayland.so, and libva-x11.so

# Short Descriptions
# libva.so - contains API functions which provide access to hardware accelerated video processing

# Required
# Xorg build environment and libdrm-2.4.124

# Recommended
# Mesa-24.3.4

# Optional
# Doxygen-1.13.2, Wayland-1.23.0, and intel-gpu-tools

# Recommended at runtime
# The VA API driver suitable for the hardware in your system: intel-vaapi-driver-2.4.1 (for Intel GPUs provided with Haswell CPUs or earlier), intel-media-driver-24.4.4 (for Intel GPUs provided with Broadwell CPUs or later), and Mesa-24.3.4 (providing the r600, radeonsi, and nouveau VA API drivers, for the ATI/AMD Radeon HD 2xxx GPUs and later, and supported NVIDIA GPUs; there is a circular dependency, read the Mesa page for information on how to break it)

cd build &&

meson setup --prefix=$XORG_PREFIX --buildtype=release
ninja

ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	meson setup --prefix=/usr            \
				--libdir=/usr/lib32      \
				--buildtype=release
	ninja
	DESTDIR=$PWD/DESTDIR ninja install   
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"          \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	meson setup --prefix=/usr            \
				--libdir=/usr/libx32      \
				--buildtype=release

	ninja
	DESTDIR=$PWD/DESTDIR ninja install   
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBVA
