DESCRIPTION="The libuv package is a multi-platform support library with a focus on asynchronous I/O."

EXT_VERSION=$(basename $PKG_LIBUV .tar.gz | cut -d "-" -f 2 | sed "s/v//") 

unset $ACLOCAL 

GCC15=false
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15=true

if [[ $GCC15 ]] && [ -f ../$(basename $PATCH_LIBUV) ]; then
	patch -Np1 -i ../$(basename $PATCH_LIBUV)
fi

sh autogen.sh
./configure --prefix=/usr --disable-static
make 

[[ $(command -v sphinx-build) != "" ]] && make man -C docs

# As root:
make install
[[ $(command -v sphinx-build) != "" ]] && install -Dm644 docs/build/man/libuv.1 /usr/share/man/man1

update_version_list libuv-$EXT_VERSION
