DESCRIPTION="The libusb package contains a library used by some applications for USB device access."
# libusb
# The libusb package contains a library used by some applications for USB device access. 

# Contents
# Installed Programs: None
# Installed Libraries: libusb-1.0.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/libusb-1.0 and /usr/share/doc/libusb-1.0.27

# Short Descriptions
# libusb-1.0.so - contains API functions used for accessing USB hardware

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# Doxygen-1.13.2

# Device Drivers --->
  # [*] USB support --->                                             [USB_SUPPORT]
    # <*/M>   Support for Host-side USB                                      [USB]
    # [*]     PCI based USB host interface                               [USB_PCI]
    # # These are most common USB controller drivers for PC-like systems.
    # # For modern systems often [USB_XHCI_HCD] is the only one needed
    # # even if the system has USB 2.0 ports:
    # < /*/M> xHCI HCD (USB 3.0) support                            [USB_XHCI_HCD]
    # < /*/M> EHCI HCD (USB 2.0) support                            [USB_EHCI_HCD]
    # < /*/M> OHCI HCD (USB 1.1) support                            [USB_OHCI_HCD]

EXT_VERSION=$(basename $PKG_LIBUSB .tar.bz2 | cut -d "-" -f 2) 

./configure --prefix=/usr --disable-static &&
make

if [[ $(command -v doxygen) != "" ]]; then
	pushd doc
	  doxygen -u doxygen.cfg
	  make docs
	popd
fi

# As root:
make install

if [[ $(command -v doxygen) != "" ]]; then
	install -v -d -m755 /usr/share/doc/libusb-$EXT_VERSION/apidocs
	install -v -m644    doc/api-1.0/* \
						/usr/share/doc/libusb-$EXT_VERSION/apidocs
fi

update_version_list $PKG_LIBUSB
