DESCRIPTION="The libunwind package contains a portable and efficient C programming interface (API) to determine the call-chain of a program."
# libunwind
# The libunwind package contains a portable and efficient C programming interface (API) to determine the call-chain of a program. The API additionally provides the means to manipulate the preserved (callee-saved) state of each call-frame and to resume execution at any point in the call-chain (non-local goto). The API supports both local (same-process) and remote (across-process) operation. 

# Contents
# Installed Programs: None
# Installed Libraries: libunwind.so, libunwind-coredump.so, libunwind-generic.so (symlink to libunwind-x86_64.so), libunwind-ptrace.so, libunwind-setjmp.so, and libunwind-x86_64.so (libunwind-x86.so on i686)
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/libexec/libunwind

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# texlive-20240312 (for latex2man)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBUNWIND .tar.gz | cut -d "-" -f 2) 

[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] &&  sed -i '/func.s/s/s//' tests/Gtest-nomalloc.c

./configure --prefix=/usr --disable-static &&
make

# As root:
make install

if $MULTILIB
then
	make clean
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr            	\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu 	\
				--disable-static         	\
				--disable-tests
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	cp -v DESTDIR/usr/include/libunwind-x86.h /usr/include
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	make clean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32 	\
				--disable-static         		\
				--disable-tests
	make
	# dwarf/Gfind_proc_info-lsb.c:601:8: error: assignment to 'const Elf64_Phdr *' from incompatible pointer type 'const Elf32_Phdr *' [-Wincompatible-pointer-types]
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	cp -v DESTDIR/usr/include/libunwind-x86.h /usr/include #NEEDS CORRECTED
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBUNWIND
