DESCRIPTION="The libtirpc package contains libraries that support programs that use the Remote Procedure Call (RPC) API. It replaces the RPC, but not the NIS library entries that used to be in glibc."

GCC15=false
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15=true

if [[ $GCC15 ]] && [ -f ../$(basename $PATCH_LIBTIRPC) ]; then
	patch -Np1 -i ../$(basename $PATCH_LIBTIRPC)
fi

EXT_VERSION=$(basename $PKG_LIBTIRPC .tar.bz2 | cut -d "-" -f 2) 

./configure --prefix=/usr                   \
            --sysconfdir=/etc               \
            --disable-static                \
            --disable-gssapi
make

# As root:
make install

if $MULTILIB
then
	make clean
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--sysconfdir=/etc			\
				--disable-static			\
				--disable-gssapi 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make clean
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"			\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	./configure --prefix=/usr				\
				--libdir=/usr/libx32		\
				--host=x86_64-pc-linux-gnux32	\
				--sysconfdir=/etc			\
				--disable-static			\
				--disable-gssapi 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBTIRPC
