DESCRIPTION="The libtiff package contains the TIFF libraries and associated utilities."

EXT_VERSION=$(basename $PKG_LIBTIFF .tar.gz | cut -d "-" -f 2) 

mkdir -p libtiff-build &&
cd       libtiff-build &&

CMAKE_VER=$(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1)

if [[ $CMAKE_VER == 3 ]]; then
	cmake -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libtiff-$EXT_VERSION \
		  -D CMAKE_INSTALL_PREFIX=/usr \
		  -G Ninja ..
	ninja
fi

if [[ $CMAKE_VER == 4 ]]; then
	cmake -D CMAKE_INSTALL_PREFIX=/usr ..     \
		  -D CMAKE_POLICY_VERSION_MINIMUM=3.5 \
		  -G Ninja                            \
		  -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libtiff-$EXT_VERSION
	ninja
fi

# As root:
ninja install

update_version_list libtiff-$EXT_VERSION
