DESCRIPTION="Libsndfile is a library of C routines for reading and writing files containing sampled audio data."
# Libsndfile
# Libsndfile is a library of C routines for reading and writing files containing sampled audio data. 

# Contents
# Installed Programs: sndfile-cmp, sndfile-concat, sndfile-convert, sndfile-deinterleave, sndfile-info, sndfile-interleave, sndfile-metadata-get, sndfile-metadata-set, sndfile-play, and sndfile-salvage
# Installed Libraries: libsndfile.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/share/doc/libsndfile-1.2.2

# Short Descriptions
# sndfile-cmp - compares two audio files
# sndfile-concat - concatenates two or more audio files
# sndfile-convert - converts a sound file from one format to another
# sndfile-deinterleave - splits a multi-channel into multiple single channel files
# sndfile-info - displays information about a sound file
# sndfile-interleave - converts multiple single channel files into a multi-channel file
# sndfile-metadata-get - retrieves metadata from a sound file
# sndfile-metadata-set - sets metadata in a sound file
# sndfile-play - plays a sound file
# sndfile-salvage - salvages the audio data from WAV files which are more than 4 GB in size
# libsndfile.so - contains the libsndfile API functions

# Required
# None

# Recommended
# FLAC-1.5.0, Opus-1.5.2, and libvorbis-1.3.7

# Recommended_Runtime
# None

# Optional
# alsa-lib-1.2.13, LAME-3.100, mpg123-1.32.10, Speex-1.2.1, and SQLite-3.49.1

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBSNDFILE .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr    \
            --docdir=/usr/share/doc/libsndfile-$EXT_VERSION
make

# As root:
make install

if $MULTILIB
then
	make distclean
	CC="gcc -m32" CXX="g++ -m32"         \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	./configure --prefix=/usr            \
				--libdir=/usr/lib32      \
				--host=i686-pc-linux-gnu

	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBSNDFILE
