DESCRIPTION="The libsecret package contains a GObject based library for accessing the Secret Service API. "

EXT_VERSION=$(basename $PKG_LIBSECRET .tar.xz | cut -d "-" -f 2) 

mkdir bld &&
cd    bld &&

meson setup --prefix=/usr       \
            --buildtype=release \
            -D gtk_doc=false    \
            ..                  &&
ninja

if [[ $(command -v gi-docgen) != "" ]]; then
	sed "s/api_version_major/'0.21.6'/"            \
		-i ../docs/reference/libsecret/meson.build &&
	meson configure -D gtk_doc=true                &&
	ninja
fi

# As root:
ninja install

update_version_list $PKG_LIBSECRET
