DESCRIPTION="Libraw is a library for reading RAW files obtained from digital cameras (CRW/CR2, NEF, RAF, DNG, and others)."
# librsvg
# The librsvg package contains a library and tools used to manipulate, convert and view Scalable Vector Graphic (SVG) images. 

# Contents
# Installed Programs: rsvg-convert
# Installed Libraries: librsvg-2.so and libpixbufloader-svg.so (installed in /usr/lib/gdk-pixbuf-2.0/2.10.0/loaders)
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/librsvg-2.0 and /usr/share/doc/librsvg-2.59.2

# Short Descriptions
# rsvg-convert - is used to convert images into PNG, PDF, PS, SVG and other formats
# librsvg-2.so - provides the functions to render Scalable Vector Graphics
# libpixbufloader-svg.so - is the Gdk Pixbuf plugin that allows GTK+ applications to render Scalable Vector Graphics images

# Required
# Cairo-1.18.2, cargo-c-0.10.11, gdk-pixbuf-2.42.12, Pango-1.56.1, and rustc-1.85.0

# Recommended
# Cairo-1.18.2, cargo-c-0.10.11, gdk-pixbuf-2.42.12, Pango-1.56.1, and rustc-1.85.0

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# docutils-0.21.2 (for man pages), Gi-DocGen-2025.3 (for documentation)

# Optional_Testing
# Xorg Fonts (for tests)

EXT_VERSION=$(basename $PKG_LIBRAW .tar.gz | cut -d "-" -f 2) 

./configure --prefix=/usr    \
            --enable-jpeg    \
            --enable-jasper  \
            --enable-lcms    \
            --disable-static \
            --docdir=/usr/share/doc/libraw-$EXT_VERSION
make

# As root:
make install

update_version_list $PKG_LIBRAW
