DESCRIPTION="The libpsl package provides a library for accessing and resolving information from the Public Suffix List (PSL). The PSL is a set of domain names beyond the standard suffixes, such as .com."
# libpsl
# The libpsl package provides a library for accessing and resolving information from the Public Suffix List (PSL). The PSL is a set of domain names beyond the standard suffixes, such as .com.

# Contents
# Installed Programs: psl
# Installed Libraries: libpsl.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# psl - queries the Public Suffix List
# libpsl.so - contains a library used to access the Public Suffix List

# Required
# None

# Recommended
# libidn2-2.3.7 and libunistring-1.3

# Optional
# ICU-76.1 (may be used instead of libidn2), libidn-1.42 (may be used instead of libidn2)

# Optional_Documentation
# GTK-Doc-1.34.0

# Optional_Testing
# Valgrind-3.24.0 (for tests)

#EXT_VERSION=$(basename $PKG_LIBPSL .tar.gz | cut -d "-" -f 2)

mkdir build &&
cd    build &&

meson setup --prefix=/usr --buildtype=release
# --buildtype=release: Specify a buildtype suitable for stable releases of the package, as the default may produce unoptimized binaries.

ninja


# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	meson setup .. 							\
				--prefix=/usr 				\
				--libdir=/usr/lib32			\
				--buildtype=release
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	meson setup .. 								\
				--prefix=/usr 					\
				--libdir=/usr/libx32			\
				--buildtype=release
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBPSL
