DESCRIPTION="The libportal package provides a library that contains GIO-style async APIs for most Flatpak portals."

EXT_VERSION=$(basename $PKG_LIBPORTAL .tar.gz | cut -d "-" -f 2) 

unset CPLUS_INCLUDE_PATH

if [ -e /usr/include/libportal ]; then
    rm -rf /usr/include/libportal.old &&
    mv -vf /usr/include/libportal{,.old}
fi

mkdir build &&
cd    build &&

meson setup --prefix=/usr --buildtype=release -D docs=false .. &&
ninja

if [[ $(command -v gi-docgen) != "" ]]; then
	sed -i "/output/s/-1/-0.9.1/" ../doc/meson.build &&
	meson configure -D docs=true                     &&
	ninja
fi

# As root:
ninja install

update_version_list $PKG_LIBPORTAL
