DESCRIPTION="The libpng package contains libraries used by other programs for reading and writing PNG files."
# libpng
# The libpng package contains libraries used by other programs for reading and writing PNG files. The PNG format was designed as a replacement for GIF and, to a lesser extent, TIFF, with many improvements and extensions and lack of patent problems.

# Contents
# Installed Programs: libpng-config (symlink), libpng16-config, pngfix and png-fix-itxt
# Installed Libraries: libpng.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/libpng16 and /usr/share/doc/libpng-1.6.46

# Short Descriptions
# pngfix - tests, optimizes and optionally fixes the zlib header in PNG files. Optionally, when fixing, strips ancillary chunks from the file
# png-fix-itxt - fixes PNG files that have an incorrect length field in the iTXt chunks
# libpng-config - is a shell script that provides configuration information for applications wanting to use libpng
# libpng.so - contain routines used to create and manipulate PNG format graphics files

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBPNG .tar.xz | cut -d "-" -f 2)

if [[ -f ../$(basename $PATCH_LIBPNG) ]]; then
	gzip -cd ../$(basename $PATCH_LIBPNG) | patch -p1
fi

./configure --prefix=/usr --disable-static &&
make

# As root:
make install &&
mkdir -v /usr/share/doc/libpng-$EXT_VERSION &&
cp -v README libpng-manual.txt /usr/share/doc/libpng-$EXT_VERSION

if $MULTILIB
then
	make distclean 
	CC="gcc -m32" CXX="g++ -m32" 			\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig 	\
	./configure --prefix=/usr				\
            --libdir=/usr/lib32				\
            --host=i686-pc-linux-gnu		\
            --disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr					\
            --libdir=/usr/libx32				\
            --host=x86_64-pc-linux-gnux32		\
            --disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBPNG
