DESCRIPTION="The libnotify library is used to send desktop notifications to a notification daemon, as defined in the Desktop Notifications spec."

EXT_VERSION=$(basename $PKG_LIBNOTIFY .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr       \
            --buildtype=release \
            -D gtk_doc=false    \
            -D man=false        \
            ..                  &&
ninja

if [[ $(command -v gi-docgen) != "" ]]; then
	sed "/docs_dir =/s@\$@ / 'libnotify'@" \
		-i ../docs/reference/meson.build   &&
	meson configure -D gtk_doc=true        &&
	ninja
fi

# As root:
ninja install &&
if [ -e /usr/share/doc/libnotify ]; then
  rm -rf /usr/share/doc/libnotify-0.8.6
  mv -v  /usr/share/doc/libnotify{,-0.8.6}
fi

update_version_list $PKG_LIBNOTIFY
