DESCRIPTION="libjpeg-turbo is a fork of the original IJG libjpeg which uses SIMD to accelerate baseline JPEG compression and decompression."
# libjpeg-turbo
# libjpeg-turbo is a fork of the original IJG libjpeg which uses SIMD to accelerate baseline JPEG compression and decompression. libjpeg is a library that implements JPEG image encoding, decoding and transcoding.

# Contents
# Installed Programs: fax2ps, fax2tiff, pal2rgb, ppm2tiff, raw2tiff, tiff2bw, tiff2pdf, tiff2ps, tiff2rgba, tiffcmp, tiffcp, tiffcrop, tiffdither, tiffdump, tiffgt, tiffinfo, tiffmedian, tiffset, and tiffsplit
# Installed Libraries: libtiff.so and libtiffxx.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/cmake/tiff and /usr/share/doc/tiff-4.7.0

# Short Descriptions
# cjpeg - compresses image files to produce a JPEG/JFIF file on the standard output. Currently supported input file formats are: PPM (PBMPLUS color format), PGM (PBMPLUS gray-scale format), BMP, and Targa
# djpeg - decompresses image files from JPEG/JFIF format to either PPM (PBMPLUS color format), PGM (PBMPLUS gray-scale format), BMP, or Targa format
# jpegtran - is used for lossless transformation of JPEG files
# rdjpgcom - displays text comments from within a JPEG file
# tjbench - is used to benchmark the performance of libjpeg-turbo
# wrjpgcom - inserts text comments into a JPEG file
# libjpeg.so - contains functions used for reading and writing JPEG images

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBJPEG_TURBO .tar.gz | cut -d "-" -f 3) 

mkdir build &&
cd    build &&

CMAKE_VER=$(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1)

if [[ $CMAKE_VER == 3 ]]; then
	cmake -D CMAKE_INSTALL_PREFIX=/usr        \
		  -D CMAKE_BUILD_TYPE=RELEASE         \
		  -D ENABLE_STATIC=FALSE              \
		  -D CMAKE_INSTALL_DEFAULT_LIBDIR=lib \
		  -D CMAKE_SKIP_INSTALL_RPATH=ON      \
		  -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libjpeg-turbo-$EXT_VERSION \
		  .. &&
	make
fi 

if [[ $CMAKE_VER == 4 ]]; then
	cmake -D CMAKE_INSTALL_PREFIX=/usr        \
		  -D CMAKE_BUILD_TYPE=RELEASE         \
		  -D ENABLE_STATIC=FALSE              \
		  -D CMAKE_INSTALL_DEFAULT_LIBDIR=lib \
		  -D CMAKE_POLICY_VERSION_MINIMUM=3.5 \
		  -D CMAKE_SKIP_INSTALL_RPATH=ON      \
		  -D CMAKE_INSTALL_DOCDIR=/usr/share/doc/libjpeg-turbo-$EXT_VERSION \
		  .. &&
	make
fi 

# As root:
make install

update_version_list $PKG_LIBJPEG_TURBO
