DESCRIPTION="libinput is a library that handles input devices for display servers and other applications that need to directly deal with input devices."
# libinput
# libinput is a library that handles input devices for display servers and other applications that need to directly deal with input devices. 

# Contents
# Installed Programs: libinput
# Installed Libraries: libinput.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/libinput, $XORG_PREFIX/libexec/libinput, $XORG_PREFIX/share/libinput, and (optionally) $XORG_PREFIX/share/doc/libinput-1.27.1

# Short Descriptions
# libinput - is a set of tools to interface with the libinput library
# libinput.so - contains API functions for handling input devices

# Required
# libevdev-1.13.3 and mtdev-1.1.7

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# Valgrind-3.24.0 (to run the tests), GTK-3.24.48 (to build the GUI event viewer), libunwind-1.8.1 (required for tests), libwacom-2.14.0, Doxygen-1.13.2, Graphviz-12.2.1, recommonmark-0.7.1, and sphinx_rtd_theme-3.0.2 (required to build documentation), pyparsing-3.2.1 (for one non-root test), and pytest-8.3.4 (for another non-root test)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBINPUT .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup ..                  \
      --prefix=$XORG_PREFIX     \
      --buildtype=release       \
      -D debug-gui=false        \
      -D tests=false            \
      -D libwacom=false         \
	  -D documentation=false		\
      -D udev-dir=/usr/lib/udev &&
ninja

# As root:
ninja install

# install -v -dm755      /usr/share/doc/libinput-$EXT_VERSION/html &&
# cp -rv Documentation/* /usr/share/doc/libinput-$EXT_VERSION/html

update_version_list $PKG_LIBINPUT
