DESCRIPTION="libidn2 is a package designed for internationalized string handling based on standards from the Internet Engineering Task Force (IETF)'s IDN working group, designed for internationalized domain names."
# libidn2
# libidn2 is a package designed for internationalized string handling based on standards from the Internet Engineering Task Force (IETF)'s IDN working group, designed for internationalized domain names.

# Contents
# Installed Programs: idn2
# Installed Libraries: libidn2.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/share/gtk-doc/html/libidn2

# Short Descriptions
# idn2 - is a command line interface to the internationalized domain library
# libidn2.so - contains a generic Stringprep implementation used for internationalized string handling

# Required
# libunistring-1.3

# Recommended
# None

# Optional
# git-2.48.1 and GTK-Doc-1.34.0

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_LIBIDN2 .tar.gz | cut -d "-" -f 2)

[[ ! $(command -v gtk_doc) ]] && OPTIONS="" || OPTIONS="--enable-gtk-doc"

./configure --prefix=/usr --disable-static $OPTIONS
# --disable-static: This switch prevents installation of static versions of the libraries.
# --enable-gtk-doc: Use this parameter if GTK-Doc is installed and you wish to rebuild and install the API documentation.

make

# As root:
make install

if $MULTILIB
then
	make distclean 
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--disable-static 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBIDN2
