DESCRIPTION="libidn is a package designed for internationalized string handling"
# libidn
# libidn is a package designed for internationalized string handling based on the Stringprep, Punycode and IDNA specifications defined by the Internet Engineering Task Force (IETF) Internationalized Domain Names (IDN) working group, used for internationalized domain names. This is useful for converting data from the system's native representation into UTF-8, transforming Unicode strings into ASCII strings, allowing applications to use certain ASCII name labels (beginning with a special prefix) to represent non-ASCII name labels, and converting entire domain names to and from the ASCII Compatible Encoding (ACE) form. 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBIDN .tar.gz | cut -d "-" -f 2) 

source /etc/profile

[[ $(command -v java) != "" ]] && OPTION="--enable-java" || OPTION=""
[[ $(command -v gtkdocize) != "" ]] && OPTION="$OPTION --enable-gtk-doc"

./configure --prefix=/usr --disable-static $OPTION
make

# As root:
make install

find doc -name "Makefile*" -delete
rm -rf -v doc/{gdoc,idn.1,stamp-vti,man,texi}
mkdir -pv       /usr/share/doc/libidn-$EXT_VERSION
cp -r -v doc/* /usr/share/doc/libidn-$EXT_VERSION

update_version_list $PKG_LIBIDN
