DESCRIPTION="The libgusb package contains the GObject wrappers for libusb-1.0 that makes it easy to do asynchronous control, bulk and interrupt transfers with proper cancellation and integration into a mainloop."
# blank
# The libgusb package contains the GObject wrappers for libusb-1.0 that makes it easy to do asynchronous control, bulk and interrupt transfers with proper cancellation and integration into a mainloop. 

# Contents
# Installed Programs: gusbcmd
# Installed Libraries: libgusb.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/gusb-1 and /usr/share/doc/libgusb-0.4.9 (if gi-docgen is used)

# Short Descriptions
# gusbcmd - is a debugging tool for the libgusb library
# libgusb.so - contains the libgusb API functions

# Required
# JSON-GLib-1.10.6 and libusb-1.0.27

# Recommended
# GLib-2.82.5 (with GObject Introspection), hwdata-0.392 (for usb.ids data file, which is also required for the tests), and Vala-0.56.17

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# Gi-DocGen-2025.3

# Optional_Testing
# umockdev-0.19.1

EXT_VERSION=$(basename $PKG_LIBGUSB .tar.xz | cut -d "-" -f 2) 

mkdir build
cd    build

meson setup ..            \
	  --prefix=/usr       \
	  --buildtype=release \
	  -D docs=false
ninja

if [[ $(command -v gi-docgen) != "" ]]; then
	sed -E "/output|install_dir/s/('libgusb)'/\1-${EXT_VERSION}'/" \
		-i ../docs/meson.build 
	meson configure -D docs=true
	ninja
fi

# As root:
ninja install

update_version_list $PKG_LIBGUSB
