DESCRIPTION="The libglvnd package dispatches API calls to a given driver vendor at runtime."

EXT_VERSION=$(basename $PKG_LIBGLVND .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr       \
            --buildtype=release \
            -D gles1=false      \
            -D hgl=false        \
            .. &&

ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf * &&
	CC="gcc -m32" CXX="g++ -m32"         \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	meson setup --prefix=/usr            \
				--libdir=/usr/lib32      \
				--buildtype=release      \
				-D gles1=false           \
				-D hgl=false             \
				..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf * &&
	CC="gcc -mx32" CXX="g++ -mx32"         \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig \
	meson setup --prefix=/usr            \
				--libdir=/usr/libx32      \
				--buildtype=release      \
				-D gles1=false           \
				-D hgl=false             \
				..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBGLVND
