DESCRIPTION="The libevdev package contains common functions for Xorg input drivers."
# Xorg Input Drivers
# The libevdev package contains common functions for Xorg input drivers. 

# Contents
# Installed Programs: libevdev-tweak-device, mouse-dpi-tool, and touchpad-edge-detector
# Installed Libraries: libevdev.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: $XORG_PREFIX/include/libevdev-1.0

# Short Descriptions
# libevdev-tweak-device - is a tool to change some kernel device properties
# mouse-dpi-tool - is a tool to estimate the resolution of a mouse
# touchpad-edge-detector - touchpad-edge-detector is a tool that reads the touchpad events from the kernel and calculates the minimum and maximum for the x and y coordinates, respectively
# libevdev.so - is a library of Xorg driver input functions

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# Doxygen-1.13.2 and Valgrind-3.24.0 (optional for tests)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBEVDEV .tar.gz | cut -d "-" -f 2) 

[[ $(cat /boot/config-$(uname -r) | grep "CONFIG_INPUT=y") == "" ]] && echo "Kernel INPUT is not configured" && exit -1
[[ $(cat /boot/config-$(uname -r) | grep "CONFIG_INPUT_EVDEV=y") == "" ]] && echo "Kernel INPUT_EVDEV is not configured" && exit -1
[[ $(cat /boot/config-$(uname -r) | grep "CONFIG_INPUT_MISC=y") == "" ]] && echo "Kernel INPUT_MISC is not configured" && exit -1
#[[ $(cat /boot/config-$(uname -r) | grep "INPUT_UINPUT") == "" ]]


mkdir build &&
cd    build &&

meson setup ..                  \
      --prefix=$XORG_PREFIX     \
      --buildtype=release       \
      -D documentation=disabled &&
ninja

# As root:
ninja install

update_version_list $PKG_LIBEVDEV
