DESCRIPTION="Libdrm provides a userspace library for accessing the direct rendering manager (DRM) on operating systems that support the ioctl interface. Libdrm is a low-level library, typically used by graphics drivers such as the Mesa DRI drivers, the X drivers, libva and similar projects."
# Libdrm
# Libdrm provides a userspace library for accessing the direct rendering manager (DRM) on operating systems that support the ioctl interface. Libdrm is a low-level library, typically used by graphics drivers such as the Mesa DRI drivers, the X drivers, libva and similar projects.

# Contents
# Installed Programs: None
# Installed Libraries: libdrm_amdgpu.so, libdrm_intel.so, libdrm_nouveau.so, libdrm_radeon.so, and libdrm.so
# Installed Directory: /usr/include/libdrm and /usr/share/libdrm

# Short Descriptions
# libdrm_amdgpu.so - contains the AMDGPU specific Direct Rendering Manager functions
# libdrm_intel.so - contains the Intel specific Direct Rendering Manager functions
# libdrm_nouveau.so - contains the open source nVidia (Nouveau) specific Direct Rendering Manager functions
# libdrm_radeon.so - contains the AMD Radeon specific Direct Rendering Manager functions
# libdrm.so - contains the Direct Rendering Manager API functions

# Required
# none

# Recommended
# Xorg Libraries

# Optional
# Cairo-1.18.2 (for tests), CMake-3.31.6 (could be used to find dependencies without pkgconfig files), docbook-xml-4.5, docbook-xsl-nons-1.79.2, docutils-0.21.2, and libxslt-1.1.42 (to build manual pages), libatomic_ops-7.8.2 (required by architectures without native atomic operations), Valgrind-3.24.0, and CUnit (for AMDGPU tests)

#[ -f /etc/profile.d/xorg.sh ] && source /etc/profile.d/xorg.sh || echo "xorg is missing"

#EXT_VERSION=$(basename $PKG_LIBDRM .tar.xz | cut -d "-" -f 2)

mkdir build &&
cd    build &&

[[ $(echo $XORG_PREFIX) != "" ]] && OPTION="--prefix=$XORG_PREFIX" | OPTION=""

[[ $(command -v valgrind) == "" ]] && OPTIONS="-D valgrind=disabled" || OPTIONS="-D valgrind=enabled"

meson setup $OPTION \
            --buildtype=release   \
            -D udev=true          \
            $OPTIONS  \
            ..                    
# --buildtype=release: Specify a buildtype suitable for stable releases of the package, as the default may produce unoptimized binaries.
# -D udev=true: This parameter enables support for using Udev instead of mknod.
# -D valgrind=disabled: This parameter disables building libdrm with valgrind support. This fixes building some packages that use libdrm. Change this parameter to "enabled" (or remove it) if you need support for valgrind.

ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	meson setup --prefix=/usr            \
				--buildtype=release      \
				--libdir=/usr/lib32      \
				-D tests=false           \
				-D udev=true             \
				$OPTIONS     \
				..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"          \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	meson setup --prefix=/usr            \
				--buildtype=release      \
				--libdir=/usr/libx32     \
				-D tests=false           \
				-D udev=true             \
				-D valgrind=disabled     \
				..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBDRM
