DESCRIPTION="The libarchive library provides a single interface for reading/writing various compression formats."
# libarchive
# The libarchive library provides a single interface for reading/writing various compression formats.

# Contents
# Installed Programs: bsdcat, bsdcpio, bsdtar, and bsdunzip
# Installed Libraries: libarchive.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# bsdcat - expands files to standard output
# bsdcpio - is a tool similar to cpio
# bsdtar - is a tool similar to GNU tar
# bsdunzip - is a tool similar to Info-ZIP unzip
# libarchive.so - is a library that can create and read several streaming archive formats

# Required
# None

# Recommended
# None

# Optional
# libxml2-2.13.6, LZO-2.10, Nettle-3.10.1, and pcre2-10.45

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_LIBARCHIVE .tar.xz | cut -d "-" -f 2)

[[ $(command -v xml2-config) == "" ]] && XML_OPTIONS="--without-xml2" || XML_OPTIONS=""
[[ $(command -v nettle-hash) == "" ]] && NET_OPTIONS="" || NET_OPTIONS="--with-nettle"

./configure --prefix=/usr --disable-static $XML_OPTIONS $NET_OPTIONS
make

# As root:
make install
ln -sfv bsdunzip /usr/bin/unzip

update_version_list $PKG_LIBARCHIVE
