DESCRIPTION="The LAME package contains an MP3 encoder and optionally, an MP3 frame analyzer."
# LAME
# The LAME package contains an MP3 encoder and optionally, an MP3 frame analyzer. This is useful for creating and analyzing compressed audio files. 

# Contents
# Installed Programs: lame and mp3rtp
# Installed Libraries: libmp3lame.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/lame and /usr/share/doc/lame-3.100

# Short Descriptions
# lame - creates MP3 audio files from raw PCM or .wav data
# mp3rtp - is used to encode MP3 with RTP streaming of the output
# libmp3lame.so - provides the functions necessary to convert raw PCM and WAV files to MP3 files

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# Dmalloc, Electric Fence, libsndfile-1.2.2 and NASM-2.16.03

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LAME .tar.gz | cut -d "-" -f 2) 

sed -i -e 's/^\(\s*hardcode_libdir_flag_spec\s*=\).*/\1/' configure

./configure --prefix=/usr --enable-mp3rtp --disable-static &&
make

# As root:
make pkghtmldir=/usr/share/doc/lame-$EXT_VERSION install

update_version_list $PKG_LAME
