DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."

EXT_VERSION=6.4.4
source /etc/profile
unset CPLUS_INCLUDE_PATH
LC_ALL=C.UTF-8

OPTIONS=""
#[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5"

pushd ..
[ ! -d plasma-$EXT_VERSION ] && mkdir plasma-$EXT_VERSION
cd plasma-$EXT_VERSION
url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -nc -A '*.xz' -np $url
popd

cp ../plasma-$EXT_VERSION/* .

cat > plasma-${EXT_VERSION}.md5 << "EOF"
1e80c73ad404ff95a607f46ec453ac07  kdecoration-6.4.4.tar.xz
6788dae93c3fb8d3790651c3cc13a459  libkscreen-6.4.4.tar.xz
f7075d4472969968507a72cb35168dbc  libksysguard-6.4.4.tar.xz
e45d3b003a98b53f93b027b26038a4d2  breeze-6.4.4.tar.xz
2d8a7936962ae30177c14f9cad0917ff  breeze-gtk-6.4.4.tar.xz
57485b21e575b632223946b936a11d35  layer-shell-qt-6.4.4.tar.xz
1294ad60e08e3d14263c316c5f2123c3  plasma-activities-6.4.4.tar.xz
69892c484106a65edc8669f9ff07f1de  libplasma-6.4.4.tar.xz
d2660f748364304a38534ad9f8302f65  kscreenlocker-6.4.4.tar.xz
5b2aa8e2f826a5537ce018645094bc06  kinfocenter-6.4.4.tar.xz
2a3cb2bc67a700808ee4de996fbcf7e1  kglobalacceld-6.4.4.tar.xz
5f2f27d10a309f87a7fcc7abe3f33c7a  kwayland-6.4.4.tar.xz
b5ce13deed26c030e80078997bcd3f59  aurorae-6.4.4.tar.xz
29aa486a4c9c03623f06019c4c6f4a6f  kwin-x11-6.4.4.tar.xz
38bd47faac424693d15e6cbec7bb4f8c  kwin-6.4.4.tar.xz
c89eed60be47c41acdaab7f7738474d9  plasma5support-6.4.4.tar.xz
e19f331b7233dfa00c1f9a4dc282aa6d  plasma-activities-stats-6.4.4.tar.xz
1234acb0cf42bb51fa1e44de15300daf  kpipewire-6.4.4.tar.xz
e387fc191c75643adf8647115e5b8135  plasma-workspace-6.4.4.tar.xz
f7955fe53dcfce1d3ee28385fb0460c5  plasma-disks-6.4.4.tar.xz
359c9fcedc3ee2660a7414c96f6a0888  bluedevil-6.4.4.tar.xz
8dd8c635342894da4a61dabc5820fce4  kde-gtk-config-6.4.4.tar.xz
123d1734729b0f6d66c45017d810ff10  kmenuedit-6.4.4.tar.xz
81cfc86c317b76e66c8fa69bd211580e  kscreen-6.4.4.tar.xz
2c7b043f2ec05c4b03f210dcedc0b502  kwallet-pam-6.4.4.tar.xz
5695632187671ca756c4e7185a71195e  kwrited-6.4.4.tar.xz
1a6dd6488b0125451102045aa8efdc1a  milou-6.4.4.tar.xz
2bf7e0444338ae3a792ccaf1049466ed  plasma-nm-6.4.4.tar.xz
00cbf448523569d1ecf799ffe8097961  plasma-pa-6.4.4.tar.xz
44bcf4f669bfa5dfd9b4a54f6016ba7b  plasma-workspace-wallpapers-6.4.4.tar.xz
cf1fe247a40af3e6dd5ca2ad53b327d0  polkit-kde-agent-1-6.4.4.tar.xz
96158610825e79a419a28f45bb809eb9  powerdevil-6.4.4.tar.xz
714b58e169c5d2e8c80d65ca8e284cff  plasma-desktop-6.4.4.tar.xz
35d2e17964ddda121f50098c29d4c30d  kgamma-6.4.4.tar.xz
27a3515f9ae4184b4987c83892d6b74a  ksshaskpass-6.4.4.tar.xz
#070839c487e9d8229ce8298d77480c8b  plasma-sdk-6.4.4.tar.xz
b19b0189993f7ebc509d3e24cc1e8aa0  sddm-kcm-6.4.4.tar.xz
#328b5f55fd21129c9184b7d1b672a0bf  discover-6.4.4.tar.xz
#3094f57a829def773d0f6ebb8b08f1f6  breeze-grub-6.4.4.tar.xz
#b3469dba2137b484b193a99fc064be67  breeze-plymouth-6.4.4.tar.xz
6e15c7a2bb5788b93acebde0318fae83  kactivitymanagerd-6.4.4.tar.xz
902966727cc9a5ebb4761df12e142c32  plasma-integration-6.4.4.tar.xz
#53cde99837265125361385ddf6246070  plymouth-kcm-6.4.4.tar.xz
eaeb0a047ac662cef2ecaf03a336ce91  xdg-desktop-portal-kde-6.4.4.tar.xz
b2b868b09d36cdbd77d086c3e215947e  drkonqi-6.4.4.tar.xz
2d2c9bcc3d499fadff6ba8c78e0a78d6  plasma-vault-6.4.4.tar.xz
#5c043fbaf5c84975c469472cc5880a59  plasma-browser-integration-6.4.4.tar.xz
7b9720ff5aaccfff5a9dddc2a71e4eb6  kde-cli-tools-6.4.4.tar.xz
88cf35de0ee8ca3b45474ffaf0d54432  systemsettings-6.4.4.tar.xz
5e2c2591807a58cf6cdf4e884c3dd4be  plasma-thunderbolt-6.4.4.tar.xz
#6a9b80fa6e10454556c4528c2510b2f7  plasma-mobile-6.4.4.tar.xz
#257173def078b51674cd27601828d732  plasma-nano-6.4.4.tar.xz
3c58fb9253970cb7a651088f423e0d9c  plasma-firewall-6.4.4.tar.xz
ff6d636282233f101ec9349321cc4e70  plasma-systemmonitor-6.4.4.tar.xz
3e2a5476e578a309854f7a965bd627a8  qqc2-breeze-style-6.4.4.tar.xz
9d4579bd5ce554f5d21bfe41a0fe64e6  ksystemstats-6.4.4.tar.xz
3fcde8974282d0ae737f38a2d5cc4c7e  oxygen-sounds-6.4.4.tar.xz
88e1e9c59db958a326c8e59769334eae  kdeplasma-addons-6.4.4.tar.xz
#e2af8aad6f916339a20d79b70434adde  flatpak-kcm-6.4.4.tar.xz
d6849ab3c3d626217e71ac5c571a0e56  plasma-welcome-6.4.4.tar.xz
67e934afb009c0cc85b6b5a7818dfc21  ocean-sound-theme-6.4.4.tar.xz
6a4cc6c6068851e488a85f94efe40959  print-manager-6.4.4.tar.xz
d66d7c32a5811a172ede92e86d0b050b  wacomtablet-6.4.4.tar.xz
#6df9d0417921b08811b3b37640f81ae7  kwayland-integration-6.4.4.tar.xz
#e377c170815f38c88d04fbacc6c2ba46  krdp-6.4.4.tar.xz
8bcecf5327af741a21af37a93901fd35  oxygen-6.4.4.tar.xz
#079df59ec207b0c7d9e83fd544c34af9  plasma-dialer-6.4.4.tar.xz
#2425c5d7af8b994b9b2a7b78db8a5bb3  spacebar-6.4.4.tar.xz
51b35f64a4e47bb39d1c27f1e6171ab9  spectacle-6.4.4.tar.xz
EOF

cat >  plasma-nm-${EXT_VERSION}.patch << "EOF"
diff -ruN plasma-nm/kcms/kcm_cellularnetwork/modemdetails.cpp plasma-nm-6.4.4/kcms/kcm_cellularnetwork/modemdetails.cpp
--- plasma-nm/kcms/kcm_cellularnetwork/modemdetails.cpp 2025-08-05 06:54:05.000000000 -0400
+++ plasma-nm-6.4.4/kcms/kcm_cellularnetwork/modemdetails.cpp   2025-10-06 06:42:51.756514341 -0400
@@ -287,10 +287,6 @@
         return i18n("SIM is required but missing.");
     case MM_MODEM_STATE_FAILED_REASON_SIM_ERROR:
         return i18n("SIM is available but unusable.");
-    case MM_MODEM_STATE_FAILED_REASON_UNKNOWN_CAPABILITIES:
-        return i18n("Unknown modem capabilities.");
-    case MM_MODEM_STATE_FAILED_REASON_ESIM_WITHOUT_PROFILES:
-        return i18n("eSIM is not initialized.");
     }
     return {};
 }
@@ -512,12 +508,6 @@
     case MM_MODEM_ACCESS_TECHNOLOGY_ANY:
         m_accessTechnology = i18n("Any");
         break;
-    case MM_MODEM_ACCESS_TECHNOLOGY_LTE_CAT_M:
-        m_accessTechnology = i18n("4G");
-        break;
-    case MM_MODEM_ACCESS_TECHNOLOGY_LTE_NB_IOT:
-        m_accessTechnology = i18n("4G");
-        break;
     }
 }

EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(       echo $file|sed 's|^.*/||')    # Remove directory
    name=$(      echo $pkg |sed 's|-6.*$||')   # Isolate package name
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir
	
	PLASMA_NM=false

       # Fix some build issues with qt-6.9.0 and later
       case $name in
         breeze)
           sed -e '/QList/i #include <QDebug>' \
               -i cursors/src/kcursorgen/kcursorgen.h
         ;;

         plasma-vault)
           sed -e '/QFuture/i #include <QDebug>' \
               -i kded/engine/commandresult.h
         ;;

         plasma-nm)
           PLASMA_NM=true
		   [ -f ../plasma-nm-${EXT_VERSION}.patch ] && patch -Np1 -i ../plasma-nm-${EXT_VERSION}.patch
         ;;
       esac

       mkdir build
       cd    build

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
			 -W no-dev $OPTIONS ..
			 
			 #-D CMAKE_CXX_FLAGS="-I/$KF6_PREFIX/include \
			 #-I/$KF6_PREFIX/include/PlasmaQuick" \
             

		[[ $PLASMA_NM ]] && bash prefix.sh

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig


done < plasma-${EXT_VERSION}.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

[[ $(command -v sddm) != "" ]] && systemctl restart sddm

update_version_list KDE_Plasma-${EXT_VERSION}
