DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."

EXT_VERSION=6.4.0
source /etc/profile
unset CPLUS_INCLUDE_PATH
LC_ALL=C.UTF-8

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""

pushd ..
[ ! -d plasma-$EXT_VERSION ] && mkdir plasma-$EXT_VERSION
cd plasma-$EXT_VERSION
url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -nc -A '*.xz' -np $url
popd

cp ../plasma-$EXT_VERSION/* .

cat > plasma-${EXT_VERSION}.md5 << "EOF"
ab29256fb0db4586141aef065fda11f7  kdecoration-6.4.0.tar.xz
74c9d93ea1726b3ac34b16edbfdf722e  libkscreen-6.4.0.tar.xz
f0acc9f0dbcdf6b43f623d07d6dd9d07  libksysguard-6.4.0.tar.xz
b15358e372172b115cf185be8888fd21  breeze-6.4.0.tar.xz
60e85061a614514b94c39e869eab9fc3  breeze-gtk-6.4.0.tar.xz
8fabd085f3ef636e28f5023e12d7b72a  layer-shell-qt-6.4.0.tar.xz
46aebcfabbeb08a1104990ad842087b7  plasma-activities-6.4.0.tar.xz
d7f9af70fa108891fdfdc7bcdbacc82b  libplasma-6.4.0.tar.xz
68ace328adc6863067911648754029f8  kscreenlocker-6.4.0.tar.xz
2e02a7110751d2d5cc39c159fffce85d  kinfocenter-6.4.0.tar.xz
9531a1081bd4ab12df9089e3b3697745  kglobalacceld-6.4.0.tar.xz
019459ee0186b04b076efb1230704b9f  kwayland-6.4.0.tar.xz
64b78a900de7f1186dfc911f80a50f25  aurorae-6.4.0.tar.xz
0db15ae0d3b8236b5708b11d1e9adca4  kwin-6.4.0.tar.xz
6faa4380f8d8a01af0f14f3f64197b88  kwin-x11-6.4.0.tar.xz
57928fb6feeca854065bfb7279ff8584  plasma5support-6.4.0.tar.xz
8fbecc9d6ad07ace67838f079aa5c27d  plasma-activities-stats-6.4.0.tar.xz
fdb0299ed6aecedfffe6779317353da6  kpipewire-6.4.0.tar.xz
5cbe97ccaff542eeea4bda3fe9b67c6c  plasma-workspace-6.4.0.tar.xz
bbebcebb99e240fbaef9b67602a14d36  plasma-disks-6.4.0.tar.xz
09d2fab2aef1f8c49940d80bbff29e98  bluedevil-6.4.0.tar.xz
5ff647c0346c4f3c5e7dac9d8e53a82e  kde-gtk-config-6.4.0.tar.xz
49a8b37511a1cdaf1a2b2052ddd6a82f  kmenuedit-6.4.0.tar.xz
99ccc9540c529154856edb780771f56e  kscreen-6.4.0.tar.xz
92ea37e57f4fe9e7408125c4bc4c918d  kwallet-pam-6.4.0.tar.xz
fd0422a3ce43c2aeffd6f269c798652e  kwrited-6.4.0.tar.xz
2b9b02148bbfa5694ef9a7dc5e6a03e6  milou-6.4.0.tar.xz
206b2bc380f36e987fdb64dd0b85d62c  plasma-nm-6.4.0.tar.xz
93a39623cc43cf93166d0db6622aabd0  plasma-pa-6.4.0.tar.xz
c6d6b973617401984609575a19fe637e  plasma-workspace-wallpapers-6.4.0.tar.xz
f4c7503a58835850f3e908e763131c7f  polkit-kde-agent-1-6.4.0.tar.xz
4c0beb24a76d4e7425a29dc2f1cafbd3  powerdevil-6.4.0.tar.xz
026b62655ddeb3795f343da1d82de981  plasma-desktop-6.4.0.tar.xz
f4ae090f609458cf8fd638250893d442  kgamma-6.4.0.tar.xz
c3fc9fbc66dd818b8ace98fc4ec826f3  ksshaskpass-6.4.0.tar.xz
#f214a6be67ef14e2fd8887bbf055d654 plasma-sdk-6.4.0.tar.xz
8ca084c3043c2d27177cc71eeb8efcf6  sddm-kcm-6.4.0.tar.xz
#94d9d6d5c9fbefa96e576a9d12d592f7 discover-6.4.0.tar.xz
#ed32be4fc0db273b4e082df7cc9b395a breeze-grub-6.4.0.tar.xz
#236905cf72af00738f16bb6e7e6957d6 breeze-plymouth-6.4.0.tar.xz
b9458dc36e5cb7bc3be48e82e21633ee  kactivitymanagerd-6.4.0.tar.xz
bb40df9a943771cf9e1368cb57c9441b  plasma-integration-6.4.0.tar.xz
#d928bf8615dd55b13b28d2355cb7cba4 plymouth-kcm-6.4.0.tar.xz
9531e9c6141c59b81f4ed7a0f99df788  xdg-desktop-portal-kde-6.4.0.tar.xz
caa4a3c1f0ae6695905229a21c57f19f  drkonqi-6.4.0.tar.xz
455cc7d925347006688313d459b40786  plasma-vault-6.4.0.tar.xz
#004a09514525e06acd4d8465297394e7 plasma-browser-integration-6.4.0.tar.xz
af37e343d53170491518de1c6f9f3606  kde-cli-tools-6.4.0.tar.xz
9208aeaa8b68e449556041c249797afb  systemsettings-6.4.0.tar.xz
76724c775da7cf5b496810c1a80e915b  plasma-thunderbolt-6.4.0.tar.xz
#ecf0a2caa5b52a1a176d833ca738488b plasma-mobile-6.4.0.tar.xz
#eaa30e1b12f180b7562b7bdf2953e158 plasma-nano-6.4.0.tar.xz
ea4737ace03d7bfb58d7a0d671c6ea72  plasma-firewall-6.4.0.tar.xz
81a2bd3fb271e577948793c9462cd3a1  plasma-systemmonitor-6.4.0.tar.xz
a77baaa44872719a829439f9140a72c8  qqc2-breeze-style-6.4.0.tar.xz
68dfc09f4e2ad74654ce04bdd7fbba5c  ksystemstats-6.4.0.tar.xz
516f9a1f90aaf4589efe3075d715bc71  oxygen-sounds-6.4.0.tar.xz
9e560ae5c1bd3d3d38a6bc490be3a0ab  kdeplasma-addons-6.4.0.tar.xz
#8135b7ca223abb3377abff3ebe7100a3 flatpak-kcm-6.4.0.tar.xz
742db99b866691dafda76237274c3aae  plasma-welcome-6.4.0.tar.xz
37ff9e5d6700de7db7b35082c29b85ad  ocean-sound-theme-6.4.0.tar.xz
f18203c5df40cc0f7b32129b2afaf56a  print-manager-6.4.0.tar.xz
da00273281b1f43edbd1cd73ec62e169  wacomtablet-6.4.0.tar.xz
#06bb6ad4a17444ec08799dab25d15351 kwayland-integration-6.4.0.tar.xz
#f9bfe1d27225f98150499d0e4321aad5 krdp-6.4.0.tar.xz
c75b586f786370295810ac044fedaf8d  oxygen-6.4.0.tar.xz
#f555953423ca1bee2f3818e65babcd79 plasma-dialer-6.4.0.tar.xz
#9c1eddad7aa78b7928853159f1413365 spacebar-6.4.0.tar.xz
189eb71771681c4ebc12abf0130b18c3  spectacle-6.4.0.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(       echo $file|sed 's|^.*/||')    # Remove directory
    name=$(      echo $pkg |sed 's|-6.*$||')   # Isolate package name
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir

       # Fix some build issues with qt-6.9.0 and later
       case $name in
         breeze)
           sed -e '/QList/i #include <QDebug>' \
               -i cursors/src/kcursorgen/kcursorgen.h
         ;;

         plasma-vault)
           sed -e '/QFuture/i #include <QDebug>' \
               -i kded/engine/commandresult.h
         ;;
       esac

       mkdir build
       cd    build

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
			 -D CMAKE_CXX_FLAGS="-I/$KF6_PREFIX/include \
			 -I/$KF6_PREFIX/include/PlasmaQuick" \
             -W no-dev -W no-deprecated-declarations \
			 -W no-unused-function -W no-unused-parameter \
			 -W no-sign-compare -W no-subobject-linkage \
			 -W missing-field-initializers $OPTIONS ..

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig


done < plasma-${EXT_VERSION}.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

[[ $(command -v sddm) != "" ]] && systemctl restart sddm

update_version_list KDE_Plasma-${EXT_VERSION}
