DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."

EXT_VERSION=6.3.5
source /etc/profile
unset CPLUS_INCLUDE_PATH
LC_ALL=C.UTF-8

pushd ..
[ ! -d mkdir plasma-$EXT_VERSION ] && mkdir plasma-$EXT_VERSION
cd plasma-$EXT_VERSION
url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -nc -A '*.xz' -np $url
popd

cp ../plasma-$EXT_VERSION/* .

cat > plasma-${EXT_VERSION}.md5 << "EOF"
5fb3170eb6508c65b05eae577b2b14c8  kdecoration-6.3.5.tar.xz
f75192d9b4243373d9ff73c93c6033fc  libkscreen-6.3.5.tar.xz
c29885dbb2bf812a442eb77e6b0e0b50  libksysguard-6.3.5.tar.xz
205c0f8a5754540b1f4ab5d8d11d8e5a  breeze-6.3.5.tar.xz
1d92d80dee776ca875da981edd3fd408  breeze-gtk-6.3.5.tar.xz
5ef7234446a3723adcefe10ef0bcb389  layer-shell-qt-6.3.5.tar.xz
2773cb22fab9e523404587d47f9f1f36  plasma-activities-6.3.5.tar.xz
2cd56cb43fa2b117426a21910823ee82  libplasma-6.3.5.tar.xz
6ea76de946a817b3beeb5df79a665143  kscreenlocker-6.3.5.tar.xz
575a0fdc89ad049d3a25fa0677bde1cd  kinfocenter-6.3.5.tar.xz
80d5b2fe1c78d16e647f15eb38a7d37f  kglobalacceld-6.3.5.tar.xz
55570e1c1bd2a78e794275a2a623a962  kwayland-6.3.5.tar.xz
73122335c54bfbd774af2e6f0e61d24f  kwin-6.3.5.tar.xz
3466165b3e12b4de480297f547e14312  plasma5support-6.3.5.tar.xz
1825f29e4dffd4eb1f2aab0c0cc8be80  plasma-activities-stats-6.3.5.tar.xz
0d4755bba080ca93df688620ebc557bb  kpipewire-6.3.5.tar.xz
##03cec13c31a8293d417ad9ee86b120e1  plasma-workspace-6.3.5.tar.xz
6cc3decc99d6a4122543765cdd387250  plasma-disks-6.3.5.tar.xz
adc085264cc4708cf5e535a31dd05cba  bluedevil-6.3.5.tar.xz
6568fa366d3434e021711170113d808a  kde-gtk-config-6.3.5.tar.xz
0338ebebebe22d460e515b2da5e82cf4  kmenuedit-6.3.5.tar.xz
50cdf2ecac31f07dfc306d5e0357136a  kscreen-6.3.5.tar.xz
a8c30057fa000fd4e904b31716a2303a  kwallet-pam-6.3.5.tar.xz
2242a920039728defbfcedefb7d979d3  kwrited-6.3.5.tar.xz
548e5530a66622b0c45084f013a75902  milou-6.3.5.tar.xz
fcbb0e9cfbab81cc66d73688b8861fc9  plasma-nm-6.3.5.tar.xz
b403ee698eb70e601d3bfb4de303acd7  plasma-pa-6.3.5.tar.xz
3fad6430e6ed6a428ac713b883725982  plasma-workspace-wallpapers-6.3.5.tar.xz
7809da1625625ae7e0c9d08635c4dea9  polkit-kde-agent-1-6.3.5.tar.xz
##3abd6b4c19179b9d268c1473714386fd  powerdevil-6.3.5.tar.xz
ea46933f09e5128de7cded404042d399  plasma-desktop-6.3.5.tar.xz
9cd24403eea536031286bc221cc9b9f4  kgamma-6.3.5.tar.xz
c09d6d1e59fb63804ad99c4f387f5929  ksshaskpass-6.3.5.tar.xz
018a87c99b2507e97a3ac477e7258371  plasma-sdk-6.3.5.tar.xz
5abe884ea5970f125b9c9dfcc4fab0ae  sddm-kcm-6.3.5.tar.xz
3951d212cb801598a7355d68c3049583  discover-6.3.5.tar.xz
a541d27cbd1b9b5a0d4e1dac6e55e5e7  breeze-grub-6.3.5.tar.xz
c2649c6e3416ab3186e27c4174b0b367  breeze-plymouth-6.3.5.tar.xz
73460fccf85940f3f7e68a9195246883  kactivitymanagerd-6.3.5.tar.xz
63a6892038c34f8827f4c16328cb6b94  plasma-integration-6.3.5.tar.xz
8cf07a8db9a9a757abf8988c6f7b2c40  plymouth-kcm-6.3.5.tar.xz
f90fe2e09eee7c42854327fd92793094  xdg-desktop-portal-kde-6.3.5.tar.xz
7491351b84d65a96c4dfb8840cddb7da  drkonqi-6.3.5.tar.xz
d46012b7d1b6f54130327f0253621169  plasma-vault-6.3.5.tar.xz
9af2281cf347e9256f3193b4a6e980e4  plasma-browser-integration-6.3.5.tar.xz
0d050629c0870e27b4291820625d271c  kde-cli-tools-6.3.5.tar.xz
4316e7705ddb86a3d894c90f08ea5221  systemsettings-6.3.5.tar.xz
f8a8648fc76dba0c00d7b00de3f1764f  plasma-thunderbolt-6.3.5.tar.xz
c73d65160de22562d215b4e1d785d753  plasma-mobile-6.3.5.tar.xz
5ac751a4ac757a087b7e33a0782c961c  plasma-nano-6.3.5.tar.xz
309d3edc46a236fd6211799ff9a5f6b5  plasma-firewall-6.3.5.tar.xz
475205f9fceb124377e88853e779245a  plasma-systemmonitor-6.3.5.tar.xz
d54d5abee1e908bb45b771dd8d560b85  qqc2-breeze-style-6.3.5.tar.xz
274a449dd2f8d63f1f57696f588dbaae  ksystemstats-6.3.5.tar.xz
9d8a93af9cde3b9ea5ceabbc1fbde5dc  oxygen-sounds-6.3.5.tar.xz
330aa9cbea5bcaf36b050d0f7d16a3af  kdeplasma-addons-6.3.5.tar.xz
0873b80b7ffd433b2aedb9edd910819a  flatpak-kcm-6.3.5.tar.xz
ea50c9b68c90c5944473102468290977  plasma-welcome-6.3.5.tar.xz
11d6a432c4f8b203576fa302ec9cc354  ocean-sound-theme-6.3.5.tar.xz
d983d3773f981e24d40394fcd310b210  print-manager-6.3.5.tar.xz
fd5412466537265869966bba3677062d  wacomtablet-6.3.5.tar.xz
fd4e03ccb5de6e98d2e45e8e87d76369  kwayland-integration-6.3.5.tar.xz
673dfd200ff11d19f338da0f94d6a296  krdp-6.3.5.tar.xz
82ea0985cdd21f1051f5289bb3dea39d  oxygen-6.3.5.tar.xz
0cc9fc2bbde48ed773372ccd6202e454  plasma-dialer-6.3.5.tar.xz
39b014e01b1321525e946aea1c23de03  spacebar-6.3.5.tar.xz
d6fad602653a3cce5d97b396034d72be  spectacle-6.3.5.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(       echo $file|sed 's|^.*/||')    # Remove directory
    name=$(      echo $pkg |sed 's|-6.*$||')   # Isolate package name
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir

       # Fix some build issues with qt-6.9.0 and later
       case $name in
         breeze)
           sed -e '/QList/i #include <QDebug>' \
               -i cursors/src/kcursorgen/kcursorgen.h
         ;;

         plasma-vault)
           sed -e '/QFuture/i #include <QDebug>' \
               -i kded/engine/commandresult.h
         ;;
       esac

       mkdir build
       cd    build

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
             -W no-dev ..

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig


done < plasma-${EXT_VERSION}.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

update_version_list KDE_Plasma-${EXT_VERSION}
