DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."

EXT_VERSION=6.3.4
source /etc/profile
unset CPLUS_INCLUDE_PATH
LC_ALL=C.UTF-8

pushd ..
[ ! -d mkdir plasma-$EXT_VERSION ] && mkdir plasma-$EXT_VERSION
cd plasma-$EXT_VERSION
url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -nc -A '*.xz' -np $url
popd

cp ../plasma-$EXT_VERSION/* .

cat > plasma-${EXT_VERSION}.md5 << "EOF"
f3e1448e2e21fd577c06f69c618c2f1b  kdecoration-6.3.4.tar.xz
eedff87c226c83dc2c9b6a1a0a50f226  libkscreen-6.3.4.tar.xz
a6c17f5efcecd7b6b0464f91218ea658  libksysguard-6.3.4.tar.xz
4a883878aec90d6e2ebbe0de7478fd2c  breeze-6.3.4.tar.xz
bd828a47b84b4b57790bd88bd007dea8  breeze-gtk-6.3.4.tar.xz
7d153944ba6e52837fe3c8d9f26fc802  layer-shell-qt-6.3.4.tar.xz
e78df78ebfc2311f417426cc9ddd996f  plasma-activities-6.3.4.tar.xz
f42bcadb8a62a42c346b3376fd2981f1  libplasma-6.3.4.tar.xz
044a5200bad3f150040b71e157a76695  kscreenlocker-6.3.4.tar.xz
127b461c8bdf51734f9175fa4245955e  kinfocenter-6.3.4.tar.xz
d3f9bc897dae7daa46bb53d1c1b23f25  kglobalacceld-6.3.4.tar.xz
c718d2e5fd13c46a7254289f2ee6def3  kwayland-6.3.4.tar.xz
b9c6612a60ab191c40566a13a3545787  kwin-6.3.4.tar.xz
36af1164b84965103586b8164d3cccc9  plasma5support-6.3.4.tar.xz
f8bd86a960d318fd0a2af7b9641382f0  plasma-activities-stats-6.3.4.tar.xz
390bfb8bdc4d8e8b27be9a391881eb82  kpipewire-6.3.4.tar.xz
1cd325542a4e308d8df1a09bd4e9ace4  plasma-workspace-6.3.4.tar.xz
aafc72d1ceb8ea4823f932e3cb3af2d2  plasma-disks-6.3.4.tar.xz
7a475d13ad36bd7ce806870ed9ca070b  bluedevil-6.3.4.tar.xz
e6eab1250d073dbe8c868204465f2b49  kde-gtk-config-6.3.4.tar.xz
2b1eb384d59ce8de434bda06fb8beecc  kmenuedit-6.3.4.tar.xz
16372996b0dd659b956531702e068205  kscreen-6.3.4.tar.xz
2e3598110a1fae0ef20026cfd9bfe0b8  kwallet-pam-6.3.4.tar.xz
01233590d4b6d7db9c558d5d2f3f691c  kwrited-6.3.4.tar.xz
0504ac2ee8173e7f5f60bcce44dfe108  milou-6.3.4.tar.xz
4c81802f44244d0729fa7635f6bef271  plasma-nm-6.3.4.tar.xz
a2d1827d77ccca9a54b8a58b79a7548c  plasma-pa-6.3.4.tar.xz
0bcc18a2d56ad488a4a5fa1bc2634695  plasma-workspace-wallpapers-6.3.4.tar.xz
42988173336108bce5986b83a7a1a59a  polkit-kde-agent-1-6.3.4.tar.xz
fd7418bb1d2ba7112928c22322b89404  powerdevil-6.3.4.tar.xz
3db58d15c9686712b6910c297a47f141  plasma-desktop-6.3.4.tar.xz
0cc55f1bbf594c6acd24da4521892d1f  kgamma-6.3.4.tar.xz
1b963f2d52c15e549320534b47532563  ksshaskpass-6.3.4.tar.xz
#8dd2b4b1551fbc6204af0ba39c1c67c0  plasma-sdk-6.3.4.tar.xz
0c5eb57842d4754c86574271cdbb62cc  sddm-kcm-6.3.4.tar.xz
#4eb1b8a42f11c50a13dee928c47d5d59  discover-6.3.4.tar.xz
#9364eaef1967b31a702b1df956e08cb1  breeze-grub-6.3.4.tar.xz
#4bebc465c15803998c52e613044344ed  breeze-plymouth-6.3.4.tar.xz
47517db388c0731522ef699aa170bbf3  kactivitymanagerd-6.3.4.tar.xz
23c3bfac78449a2a984d7c767594ae55  plasma-integration-6.3.4.tar.xz
#33e85137db12bf9c7d927f1cfb08ec48  plymouth-kcm-6.3.4.tar.xz
1795f3ef6ab9d77422263c28cc7b5d6a  xdg-desktop-portal-kde-6.3.4.tar.xz
3dd1d5edf698a4b0418f7b31c8e05ff6  drkonqi-6.3.4.tar.xz
cd34ed66deb75653f58bd25b1c448bca  plasma-vault-6.3.4.tar.xz
#45d54366998406975d2c711b30b5dcfd  plasma-browser-integration-6.3.4.tar.xz
df531f9157827debd487859171e03765  kde-cli-tools-6.3.4.tar.xz
1b7c0f95baf0127310439eb3dc9b579c  systemsettings-6.3.4.tar.xz
b2ac34c1b2e4e14cb9ae64da7688675b  plasma-thunderbolt-6.3.4.tar.xz
#270af2ab61e35462b59dffb956155f81  plasma-mobile-6.3.4.tar.xz
#e0eb90ac39f7d15b69533dbf702f5305  plasma-nano-6.3.4.tar.xz
043a3de01df09567cffdf25d95ec3f55  plasma-firewall-6.3.4.tar.xz
4d4d79915a5e6a353c0a25205f73629e  plasma-systemmonitor-6.3.4.tar.xz
de210cc512f5c999260f69c95995ed9a  qqc2-breeze-style-6.3.4.tar.xz
07120cf3716ab424a36034e92f9e2c25  ksystemstats-6.3.4.tar.xz
9ddeb6fe4405d8fbcd68a930951fec04  oxygen-sounds-6.3.4.tar.xz
f878ff1684509f59aba3c7c733b3eb5c  kdeplasma-addons-6.3.4.tar.xz
#b0eab2083af546fc17fd34762c48d0d5  flatpak-kcm-6.3.4.tar.xz
e6d4d57179a03ad6661a576951278ef1  plasma-welcome-6.3.4.tar.xz
8bf1a7d70ee1571cf7ecdb9714b6170b  ocean-sound-theme-6.3.4.tar.xz
5af69e4621c5a8d8ba419d5d3cd509fa  print-manager-6.3.4.tar.xz
d98fbb6b76a00f2c68393712c3ff5606  wacomtablet-6.3.4.tar.xz
#0d7359db81fa9edf32a2d74c1225b273  kwayland-integration-6.3.4.tar.xz
#5de78b2cff69d5c6b83dcd7d702e0924  krdp-6.3.4.tar.xz
69161ea6ac49acbc7fccd736d5ee0e56  oxygen-6.3.4.tar.xz
#825010eafd1720db072146037c833c71  plasma-dialer-6.3.4.tar.xz
#94ae8b36f72eade4d25fab51346b68f4  spacebar-6.3.4.tar.xz
9edf40086573404b45317242bbdf9cae  spectacle-6.3.4.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(       echo $file|sed 's|^.*/||')    # Remove directory
    name=$(      echo $pkg |sed 's|-6.*$||')   # Isolate package name
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir

       # Fix some build issues with qt-6.9.0 and later
       case $name in
         breeze)
           sed -e '/QList/i #include <QDebug>' \
               -i cursors/src/kcursorgen/kcursorgen.h
         ;;

         plasma-vault)
           sed -e '/QFuture/i #include <QDebug>' \
               -i kded/engine/commandresult.h
         ;;
       esac

       mkdir build
       cd    build

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
             -W no-dev ..

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig


done < plasma-${EXT_VERSION}.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

update_version_list KDE_Plasma-${EXT_VERSION}
