DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=6.3.3
source /etc/profile
unset CPLUS_INCLUDE_PATH
LC_ALL=C.UTF-8

url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -A '*.xz' -np $url

cat > plasma-${EXT_VERSION}.md5 << "EOF"
848402e26cc050bc2327af82cb923097  kdecoration-6.3.3.tar.xz
5b899601078f5e4962be49bbb81f25d3  libkscreen-6.3.3.tar.xz
3bbf1606830731a5e54413822740672f  libksysguard-6.3.3.tar.xz
#17e534d0dc8ad0f2fff2cf1e0a931b19  breeze-6.3.3.tar.xz #?
#5fbd202e3b3f7079c3d64bcc1871e54b  breeze-gtk-6.3.3.tar.xz #?
34a54212ea43be36936e53dbaf9cab0d  layer-shell-qt-6.3.3.tar.xz
3ba50ff79eec56c97dad6e80144d003d  plasma-activities-6.3.3.tar.xz
ffdfd77c236a92796a075437fb2b8fa9  libplasma-6.3.3.tar.xz
2fab242ae01ca62a849b1a101591de48  kscreenlocker-6.3.3.tar.xz
27818b89503b78803aa7ac039e5592b7  kinfocenter-6.3.3.tar.xz
4a3ad0c0e9b2436a52b1b2fa58006ade  kglobalacceld-6.3.3.tar.xz
4467180a637d3cac5ca97a26941b40c8  kwayland-6.3.3.tar.xz
a991f6d1061938837110f2799c6e3057  kwin-6.3.3.1.tar.xz
#806dfb30148951f41652a89789001db8  kwin-6.3.3.tar.xz
b58b502e77e1bb8239d452080adb4a3c  plasma5support-6.3.3.tar.xz
841d7945c6fabc2abb5b5e29a2b3085d  plasma-activities-stats-6.3.3.tar.xz
5742828254c8ea7df39d56baa7e78720  kpipewire-6.3.3.tar.xz
d7518a609154b2fa32533eabb5416870  plasma-workspace-6.3.3.tar.xz
37ed79344cb4afd6c3ce35c7aacc55a8  plasma-disks-6.3.3.tar.xz
1f0be04a1114ec146a0141460a145097  bluedevil-6.3.3.tar.xz
a61764a4b2c1a7cbf8df524dd7a2622f  kde-gtk-config-6.3.3.tar.xz
8ecb2511519e3a700ced0ddd6e284934  kmenuedit-6.3.3.tar.xz
ce280020d1d3f98f51619bf456e2a596  kscreen-6.3.3.tar.xz
ba561cdaa17633c2230dd3ca42b258fc  kwallet-pam-6.3.3.tar.xz
c1ba598ed34c81190fcb62ab15e2237d  kwrited-6.3.3.tar.xz
81b76ff6d8789c55c3af797650ecce8c  milou-6.3.3.tar.xz
81c412ff6c4f110caf22e4725afc101e  plasma-nm-6.3.3.tar.xz
8a9b30eea928de9f2885c9cad45f92ff  plasma-pa-6.3.3.tar.xz
02858ab8953f7f96a4abddf82e77432a  plasma-workspace-wallpapers-6.3.3.tar.xz
51a8bb486e56a23dcf3016da1db796da  polkit-kde-agent-1-6.3.3.tar.xz
b2a8ade1df97b5a243b86ab72b62a6b4  powerdevil-6.3.3.tar.xz
963d454ac08075e00b348cd991b9ebf7  plasma-desktop-6.3.3.tar.xz
c0db6f15fa86ad13e81cc6c74df21205  kgamma-6.3.3.tar.xz
76fffc04576b64fa1868ab2822dbda6f  ksshaskpass-6.3.3.tar.xz
#64b95212f56f535c31437100010e0235  plasma-sdk-6.3.3.tar.xz
2ad5086625b10e41dfc38381f1345ee3  sddm-kcm-6.3.3.tar.xz
#72f1a00c931ba87fba548ce5e34babb1  discover-6.3.3.tar.xz
#e6537f58f7e6d2d45f460a530262917f  breeze-grub-6.3.3.tar.xz
#ef959ae0b920aef8560924366f8526b3  breeze-plymouth-6.3.3.tar.xz
c1ca1aaa11ff5c1903d4ba791e1aebf1  kactivitymanagerd-6.3.3.tar.xz
726a661f905160f2047ccbbfd3ae2d3b  plasma-integration-6.3.3.tar.xz
#4b1c8f82b008a5524d740320e1d4de79  plymouth-kcm-6.3.3.tar.xz
f4b4290695d2a236c9d7d5a3b11c5261  xdg-desktop-portal-kde-6.3.3.tar.xz
382dbda5e5161700cb1ced05d3825ce1  drkonqi-6.3.3.tar.xz
a5eebbfd314c7d081302cc8db59272af  plasma-vault-6.3.3.tar.xz
#d50efe6b039f7aecc196fd9a39eed3c5  plasma-browser-integration-6.3.3.tar.xz
ab20e2e5a0f8eb2d3b5cf1ee6ce313ad  kde-cli-tools-6.3.3.tar.xz
1175a94991cf6aaebccf9acd6f08a67a  systemsettings-6.3.3.tar.xz
8f35f0efc2559e3c19531f6ab46c98d1  plasma-thunderbolt-6.3.3.tar.xz
#a8a8987bbfa7bf89667d1be6432da2b3  plasma-mobile-6.3.3.tar.xz
#801f7d64ca7e44222ef864b1d63a6400  plasma-nano-6.3.3.tar.xz
8636001db666785a9c10e0a074e1ff45  plasma-firewall-6.3.3.tar.xz
2474fbfb2b6fe7a4d51b70c8bc2d75f4  plasma-systemmonitor-6.3.3.tar.xz
31e713d033b6e8f015ff30e081637c02  qqc2-breeze-style-6.3.3.tar.xz
d353e512efa727e463a02086b7c26123  ksystemstats-6.3.3.tar.xz
8bb063011695926012e7ce06d648aac8  oxygen-sounds-6.3.3.tar.xz
70f0aae757a39450eb0cc59a89b7c9bf  kdeplasma-addons-6.3.3.tar.xz
#1c75ae08e0f9f1cf80e649e34a65fc26  flatpak-kcm-6.3.3.tar.xz
1b8c94d687ca0e8fbd02476d8a09688b  plasma-welcome-6.3.3.tar.xz
972d10d6c011d4ef0e3eddb4dcfbfc21  ocean-sound-theme-6.3.3.tar.xz
3ceaea3b8cddb314a0717c2c634cb8aa  print-manager-6.3.3.tar.xz
2260b7716e8f1bd9c49aff9e19fb74dc  wacomtablet-6.3.3.tar.xz
#3bb7d4cceb33e60f3d098f0ca8366525  kwayland-integration-6.3.3.tar.xz
#b32095d9c57e49e448e9e6b05877b9a4  krdp-6.3.3.tar.xz
04da37f50413d997c78e7c5e5cf9c68f  oxygen-6.3.3.tar.xz
#9c669f734ffda950296d293cb9e700db  plasma-dialer-6.3.3.tar.xz
#180746bbcd6450bd86968da066428259  spacebar-6.3.3.tar.xz
34ee61a0280b76a439fa5e90adb8c0bd  spectacle-6.3.3.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')           # Remove directory
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir

       mkdir build
       cd    build

	name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

	# Glitch in drkonqi where it will always reach out for pygdbmi psutil entry_sdk instead fo the local copies.
	# This patch installs the local version
      case $name in 
		drkonqi)
			mkdir -p src/data/python
			pushd src/data/python
			cp -r /usr/lib/python*/site-packages/pygdbmi-*.dist-info/ .
			cp -r /usr/lib/python*/site-packages/psutil-*.dist-info/ .
			cp -r /usr/lib/python*/site-packages/sentry_sdk-*.dist-info/ .
			cp -r /usr/lib/python*/site-packages/pygdbmi/ .
			cp -r /usr/lib/python*/site-packages/psutil/ .
			cp -r /usr/lib/python*/site-packages/sentry_sdk/ .
			popd
			;;
      esac

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
             -W no-dev ..

	# This patch prevents the actual download
      case $name in
		drkonqi)
			#sed -i "s@cd /var/local/extension/sources/kde_plasma/drkonqi-6.3.3/build/src/data@#cd /var/local/extension/sources/kde_plasma/drkonqi-6.3.3/build/src/data@" src/data/CMakeFiles/python_vendor.dir/build.make
			sed -i "s@&& /usr/bin/pip3 install --target@#&& /usr/bin/pip3 install --target@" src/data/CMakeFiles/python_vendor.dir/build.make
			;;
      esac

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig

done < plasma-${EXT_VERSION}.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

update_version_list KDE_Plasma-${EXT_VERSION}
