DESCRIPTION="KDE Plasma is a collection of packages based on top of KDE Frameworks and QML. They implement the KDE Display Environment (Plasma)."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=6.3.2

url=https://download.kde.org/stable/plasma/${EXT_VERSION}/
wget -r -nH -nd -A '*.xz' -np $url

mv spectacle-6.3.2.1.tar.xz spectacle-6.3.2.tar.xz

cat > plasma-6.3.2.md5 << "EOF"
34c760dc07f498d800c78013e89720b8  kdecoration-6.3.2.tar.xz
1a23a3c130d5a73e851556638e05c86a  libkscreen-6.3.2.tar.xz
f8d52a88a1b4bb492fb4c590d93efd9f  libksysguard-6.3.2.tar.xz
7d88c11927b7254a48c239f8ff833161  breeze-6.3.2.tar.xz
7c23c6cca6ae3b75c7d6e338d655f6be  breeze-gtk-6.3.2.tar.xz
f56e4b5f766ddf07974646305e32f86e  layer-shell-qt-6.3.2.tar.xz
c1ee6ea5e63f87819e53aae19e7175f5  plasma-activities-6.3.2.tar.xz
d98a720f6c7bf6b18f68eaa0842454c9  libplasma-6.3.2.tar.xz
97d0ef783470792339b0ab04325bc374  kscreenlocker-6.3.2.tar.xz
cb1b7c21781685de53e066ed83f0ec88  kinfocenter-6.3.2.tar.xz
153b3403440f5376a170055b3e0e7740  kglobalacceld-6.3.2.tar.xz
425782c861e1b1bf0bb49a782b402cd6  kwayland-6.3.2.tar.xz
e4c54188e25914eb0d0e5693b0e6332c  kwin-6.3.2.1.tar.xz
#309881e87eab586be5448455f4d81b19  kwin-6.3.2.tar.xz
0c0eaea9839bff9b0ac70e09814618f2  plasma5support-6.3.2.tar.xz
b59f54a9c59f5633d4141f9acd6369ce  plasma-activities-stats-6.3.2.tar.xz
dbdc3c9f45d0e0e09ab2b6cf6b6b75d7  kpipewire-6.3.2.tar.xz
b83418536dead5549a9c87eaf7b1fe4d  plasma-workspace-6.3.2.tar.xz
5737bfdf712844e76b0da0acedd8f339  plasma-disks-6.3.2.tar.xz
62d50988f3833ed98e22a0c6fbb805ff  bluedevil-6.3.2.tar.xz
dfd47627bc8da5c5b53475214a648b28  kde-gtk-config-6.3.2.tar.xz
06577237fc872fb7659b11e829594144  kmenuedit-6.3.2.tar.xz
77dba21438203d747f9361ef91e3f27b  kscreen-6.3.2.tar.xz
2b880797d9e6ccd1cba40285436b1789  kwallet-pam-6.3.2.tar.xz
bf7edbc9fd326ab2764e1244e6835ffa  kwrited-6.3.2.tar.xz
7d787ff90098760bf8eb5db7fd833bc8  milou-6.3.2.tar.xz
1b9dd5ae4ebf274bc282d2636af50fbb  plasma-nm-6.3.2.tar.xz
281ec80a71b3942a8d42a5132682f1bc  plasma-pa-6.3.2.tar.xz
0f225ead05e73c43599a66cd6d796cc6  plasma-workspace-wallpapers-6.3.2.tar.xz
5bdd87252dc6713f4b9ebd44e2caaf4e  polkit-kde-agent-1-6.3.2.tar.xz
29608ea71ab87f3491adcb5584ca8dc9  powerdevil-6.3.2.tar.xz
f323dda4120302a0759fe81679c9dbd6  plasma-desktop-6.3.2.tar.xz
4353d584447fb28011637ed3d85b4920  kgamma-6.3.2.tar.xz
e278489c407a411270f70d945f6d6a51  ksshaskpass-6.3.2.tar.xz
#bf4d0d25e309e930cbf867b0f4460e51  plasma-sdk-6.3.2.tar.xz
2b4b42f97b187209a6d93f7167b793ca  sddm-kcm-6.3.2.tar.xz
#05dd805ad6eaaa6563ac16ef413f8ad3  discover-6.3.2.tar.xz
#037192907099c3a3edcceee135336040  breeze-grub-6.3.2.tar.xz
#5e2b70c2282b5597f86008e3bf27b632  breeze-plymouth-6.3.2.tar.xz
a7846a4612e60ac416b1db227d208e95  kactivitymanagerd-6.3.2.tar.xz
477b200bc4bc43344529a835c5e607a3  plasma-integration-6.3.2.tar.xz
#9b3e41e24234f6c01f64739babcede7a  plymouth-kcm-6.3.2.tar.xz
79cea0f52385ce4bb8448a0f7b17f212  xdg-desktop-portal-kde-6.3.2.tar.xz
6fd748a372f52c33ce869b58b7d5fe18  drkonqi-6.3.2.tar.xz
ed431307e4784a87bd24576df4394e6e  plasma-vault-6.3.2.tar.xz
#6ed2a9395f7e569ca38875c44db408db  plasma-browser-integration-6.3.2.tar.xz
147069fdc10dea3a7a7701df9fd2d9ee  kde-cli-tools-6.3.2.tar.xz
3a846d5cf8d923780e21f011ae2ceb17  systemsettings-6.3.2.tar.xz
8b43cda434ae5d88c9436e3d4b793164  plasma-thunderbolt-6.3.2.tar.xz
#5c1c23af1627d25842bfc28dc56fe048  plasma-mobile-6.3.2.tar.xz
#9a07133320259913c5a826b5256f86d8  plasma-nano-6.3.2.tar.xz
488fc23da31e10dd7bc2a1e36ee6716d  plasma-firewall-6.3.2.tar.xz
602917d54289a02a6711f215dae470bb  plasma-systemmonitor-6.3.2.tar.xz
361d1a0da813fd82bd36e11fcc4b157b  qqc2-breeze-style-6.3.2.tar.xz
b26d38fb9f9d83b27bcafaec1597843a  ksystemstats-6.3.2.tar.xz
2102f13838581d36a8247e2b54fff369  oxygen-sounds-6.3.2.tar.xz
ba8261586695cccdb01a6de8d400281c  kdeplasma-addons-6.3.2.tar.xz
#b32d6d4486fd549d61aeff96c1dfff85  flatpak-kcm-6.3.2.tar.xz
8d3998b1e171ee55c91a419cc8ba6319  plasma-welcome-6.3.2.tar.xz
faf86ec8c776cd351c1a96ed70328da3  ocean-sound-theme-6.3.2.tar.xz
f7a577b9baf316504e2ab9481f376008  print-manager-6.3.2.tar.xz
7d06df172f05b46ea6e97ae41f6e8be7  wacomtablet-6.3.2.tar.xz
#8575d2950cff501301f92426145e3056  kwayland-integration-6.3.2.tar.xz
#3679989f3a64f9c5b976175267119334  krdp-6.3.2.tar.xz
b812507c2d6720a1a9aca4e38b993f68  oxygen-6.3.2.tar.xz
#99b5985ac398900121545d03ab54530e  plasma-dialer-6.3.2.tar.xz
#ffeddc23f3e90de981301940b21550d0  spacebar-6.3.2.tar.xz
e9fc02ced53504b97341e0f248c63ee8  spectacle-6.3.2.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')           # Remove directory
    packagedir=$(echo $pkg |sed 's|\.tar.*||') # Source directory

    tar -xf $file
    pushd $packagedir

       mkdir build
       cd    build

       cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
             -D CMAKE_INSTALL_LIBEXECDIR=libexec \
             -D CMAKE_BUILD_TYPE=Release         \
             -D BUILD_QT5=OFF                    \
             -D BUILD_TESTING=OFF                \
             -W no-dev ..  &&

        make
        make install
    popd


    rm -rf $packagedir
    /sbin/ldconfig

done < plasma-6.3.2.md5

# Setup xsessions (X11 sessions)
install -dvm 755 /usr/share/xsessions
cd /usr/share/xsessions

[ -e plasma.desktop ] || ln -sfv $KF6_PREFIX/share/xsessions/plasmax11.desktop 

# Setup wayland-sessions 
install -dvm 755 /usr/share/wayland-sessions
cd /usr/share/wayland-sessions

[ -e plasmawayland.desktop ] || ln -sfv $KF6_PREFIX/share/wayland-sessions/plasma.desktop

# Setup xdg-desktop-portal
install -dvm 755 /usr/share/xdg-desktop-portal
cd /usr/share/xdg-desktop-portal 

[ -e kde-portals.conf ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/kde-portals.conf

# Setup kde portal
install -dvm 755 /usr/share/xdg-desktop-portal/portals
cd /usr/share/xdg-desktop-portal/portals

[ -e kde.portal ] || ln -sfv $KF6_PREFIX/share/xdg-desktop-portal/portals/kde.portal

cat > /etc/pam.d/kde << "EOF"
# Begin /etc/pam.d/kde

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde
EOF

cat > /etc/pam.d/kde-np << "EOF"
# Begin /etc/pam.d/kde-np

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account  include        system-account
password include        system-password
session  include        system-session

# End /etc/pam.d/kde-np
EOF

cat > /etc/pam.d/kscreensaver << "EOF"
# Begin /etc/pam.d/kscreensaver

auth    include system-auth
account include system-account

# End /etc/pam.d/kscreensaver
EOF

cat > ~/.xinitrc << "EOF"
dbus-launch --exit-with-x11 $KF6_PREFIX/bin/startplasma-x11
EOF

update_version_list $PKG_BLANK
