DESCRIPTION="KDE Frameworks is a collection of libraries based on top of Qt6 and QML derived from the previous KDE libraries."

EXT_VERSION=6.15.0

# KDE Frameworks 6 Pre-installation Configuration
#export KF6_PREFIX=/opt/kf6

source /etc/profile
export LC_ALL=C.UTF-8

if [[ $(cat /etc/profile.d/kf6.sh | grep "# Begin /etc/profile.d/kf6.sh") == "" ]]; then
cat > /etc/profile.d/kf6.sh << "EOF"
# Begin /etc/profile.d/kf6.sh

export KF6_PREFIX=/opt/kf6

pathappend $KF6_PREFIX/bin              PATH
pathappend $KF6_PREFIX/lib/pkgconfig    PKG_CONFIG_PATH

pathappend $KF6_PREFIX/etc/xdg          XDG_CONFIG_DIRS
pathappend $KF6_PREFIX/share            XDG_DATA_DIRS

pathappend $KF6_PREFIX/lib/plugins      QT_PLUGIN_PATH
pathappend $KF6_PREFIX/lib/plugins/kcms QT_PLUGIN_PATH

pathappend $KF6_PREFIX/lib/qml          QML2_IMPORT_PATH

pathappend $KF6_PREFIX/lib/python3.13/site-packages PYTHONPATH

pathappend $KF6_PREFIX/include          CPLUS_INCLUDE_PATH
# End /etc/profile.d/kf6.sh
EOF
fi

if [[ $(cat /etc/profile.d/qt6.sh | grep "# Begin Qt6 changes for KF6") == "" ]]; then
cat >> /etc/profile.d/qt6.sh << "EOF"
# Begin Qt6 changes for KF6

pathappend /usr/lib/plugins            QT_PLUGIN_PATH
pathappend $QT6DIR/plugins             QT_PLUGIN_PATH
pathappend $QT6DIR/qml                 QML2_IMPORT_PATH

# End Qt6 changes for KF6
EOF
fi

if [[ $(cat /etc/ld.so.conf | grep "/opt/kf6/lib") == "" ]]; then
cat >> /etc/ld.so.conf << "EOF"
# Begin KF6 addition

/opt/kf6/lib

# End KF6 addition
EOF
fi

[ -h $KF6_PREFIX/etc/dbus-1 ] && unlink $KF6_PREFIX/etc/dbus-1
[ -h $KF6_PREFIX/share/dbus-1 ] && unlink $KF6_PREFIX/share/dbus-1
[ -h $KF6_PREFIX/share/polkit-1 ] && unlink $KF6_PREFIX/share/polkit-1
[ -h $KF6_PREFIX/lib/systemd ] && unlink $KF6_PREFIX/lib/systemd
[ -d $KF6_PREFIX/lib/systemd ] && rm -r $KF6_PREFIX/lib/systemd

[ -h /opt/kf6 ] && unlink /opt/kf6

[ -d /opt/kf6.old ] && rm -r /opt/kf6.old

if [ -d /opt/kf6 ]; then
	mv -v /opt/kf6 /opt/kf6.old                         &&
	install -v -dm755           $KF6_PREFIX/{etc,share} &&
	ln -sfv /etc/dbus-1         $KF6_PREFIX/etc         &&
	ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share       &&
	ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share       &&
	install -v -dm755           $KF6_PREFIX/lib         &&
	ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib
fi

install -v -dm755           $KF6_PREFIX/{etc,share}
ln -sfv /etc/dbus-1         $KF6_PREFIX/etc
[ -d $KF6_PREFIX/share/dbus-1 ] && rm -r $KF6_PREFIX/share/dbus-1
ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share
ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share
install -v -dm755           $KF6_PREFIX/lib
ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib

install -v -dm755                $KF6_PREFIX/share/icons
[ -d $KF6_PREFIX/share/icons/hicolor ] && rm -r $KF6_PREFIX/share/icons/hicolor
ln -sfv /usr/share/icons/hicolor $KF6_PREFIX/share/icons

[ -h /opt/kf6-$EXT_VERSION ] && unlink /opt/kf6-$EXT_VERSION
[ -d /opt/kf6-$EXT_VERSION ] && rm -r /opt/kf6-$EXT_VERSION

#mv /opt/kf6{,-$EXT_VERSION}
#ln -sfv kf6-$EXT_VERSION /opt/kf6



url=https://download.kde.org/stable/frameworks/6.15/
wget -r -nH -nd -A '*.xz' -np $url

cat > frameworks-${EXT_VERSION}.md5 << "EOF"
28589bafd641e95fe589887652b40b4d  attica-6.15.0.tar.xz
#014f6e691ca5dc47cee5808d1205258e  extra-cmake-modules-6.15.0.tar.xz
a154dd24395091cf46a1a1817d9ca2c0  kapidox-6.15.0.tar.xz
c0d4a4f6f2bce3e22247f501147740e7  karchive-6.15.0.tar.xz
e00c24fac305d8c16f5c0c0cd63f132f  kcodecs-6.15.0.tar.xz
dd621450043a81b95b404e9e9fb73eb9  kconfig-6.15.0.tar.xz
9cff5a3522fc1450e1b26b8b6fb81f7b  kcoreaddons-6.15.0.tar.xz
060f28c494d49e1c242f90f4c1b1802d  kdbusaddons-6.15.0.tar.xz
a3431dbb6d6d0ae124f6b16c024a3bc2  kdnssd-6.15.0.tar.xz
d17d59371cb0dd8aaa79f19850c59176  kguiaddons-6.15.0.tar.xz
de54a5b5301449361c39452dcf0c1f4b  ki18n-6.15.0.tar.xz
d84e8ac84b003e8ea74b7cc3e41ae9ad  kidletime-6.15.0.tar.xz
e5db1c0f98c5766415b7554eea1025b7  kimageformats-6.15.0.tar.xz
f202b6a915444f6f5006f2525453cc24  kitemmodels-6.15.0.tar.xz
9b2d88606da21560e486ba24f6cd5a5a  kitemviews-6.15.0.tar.xz
8325218897db9b70d446771c6d3b0cdd  kplotting-6.15.0.tar.xz
fdd83ee529c232e0a2eb32296796c588  kwidgetsaddons-6.15.0.tar.xz
3e948a6cb549994adaee269ce1ca92d2  kwindowsystem-6.15.0.tar.xz
70ec66ffabd71d8a4ef75bf16e1d0112  networkmanager-qt-6.15.0.tar.xz
53030564c7c8573daf90830f6eebd947  solid-6.15.0.tar.xz
03b7b199bf7c2e7461dcd632c1097c64  sonnet-6.15.0.tar.xz
1935da1bb7251e4af64e7796ebf6b542  threadweaver-6.15.0.tar.xz
fc2304a9b2ecfb1e77e7e7b9f5626380  kauth-6.15.0.tar.xz
fbe407870826ecec177c92615d1108dc  kcompletion-6.15.0.tar.xz
6e4edeb6212e36f9cbb299e54fd80e69  kcrash-6.15.0.tar.xz
5d654b4f304a6d991630b9bb2fadcba5  kdoctools-6.15.0.tar.xz
bb4605ac2315a14b92c7f224251559eb  kpty-6.15.0.tar.xz
4d8b128e5309e1d36a52138d3ee98ce6  kunitconversion-6.15.0.tar.xz
ffdef89fbe0ee0b8fccadbd9aac8da47  kcolorscheme-6.15.0.tar.xz
63d99f7500d2f61cbd0021716d518745  kconfigwidgets-6.15.0.tar.xz
9a797dc85b0cb0ca490d81f78ac38e7b  kservice-6.15.0.tar.xz
279949672c16e438dd9383f0482c345e  kglobalaccel-6.15.0.tar.xz
e42fe98706f6ce010f6b7e68e45723e0  kpackage-6.15.0.tar.xz
dc96a196b58370f33a2729db718ba42a  kdesu-6.15.0.tar.xz
02f53dfc514c4ca208bfdb318a810b72  kiconthemes-6.15.0.tar.xz
812aaf880af0ffb0cbe9b63000b19d62  knotifications-6.15.0.tar.xz
3fbcdf766a2129c7c36b7abd31795453  kjobwidgets-6.15.0.tar.xz
92a972008d2a47ecfeab3a9075102f6e  ktextwidgets-6.15.0.tar.xz
5a444d4afebd2c1b64765a1e2f7cfdfa  kxmlgui-6.15.0.tar.xz
94ed39aef9316924c078e0b7bc7a24e7  kbookmarks-6.15.0.tar.xz
791f270c78c3537987cca1aca25dddc0  kwallet-6.15.0.tar.xz
33b8abe3ac1f73ffccf185598555956c  kded-6.15.0.tar.xz
0adc99f935bd62a324c091bbb667b0ef  kio-6.15.0.tar.xz
0d85516132dee7bbe78be56fa53e9d31  kdeclarative-6.15.0.tar.xz
21054fbb5a520f53028e4e1e230529fa  kcmutils-6.15.0.tar.xz
7e01433e0e2d6e118cce4194e07dcd0c  kirigami-6.15.0.tar.xz
30b8460c463469e75012541569931b28  syndication-6.15.0.tar.xz
70f9e01f19c1efd7505745dba2cc9b23  knewstuff-6.15.0.tar.xz
d907c070c53a2a350aa79afc9a012544  frameworkintegration-6.15.0.tar.xz
c43cdfe7f41cd5bda0547a4a7b17a3ef  kparts-6.15.0.tar.xz
16971213402be0b51ed21581f462721c  syntax-highlighting-6.15.0.tar.xz
6c06c785c5f7c0a1c2533bb1bdf5fd9f  ktexteditor-6.15.0.tar.xz
9151ee22165242898811bca58c177914  modemmanager-qt-6.15.0.tar.xz
0a5641dd0fd0334feb63cf15d1b9779b  kcontacts-6.15.0.tar.xz
db479f08002ac2ef0a76995053e08fa5  kpeople-6.15.0.tar.xz
f7ce25d22d44467169336cecb057185c  bluez-qt-6.15.0.tar.xz
0613e13f6736d6d11162ce4260565b65  kfilemetadata-6.15.0.tar.xz
036bd6c127bee1136bd4f90cf3930e0b  baloo-6.15.0.tar.xz
#cc8e8c888f0a00fd0a2c23e19b20f6f0  breeze-icons-6.15.0.tar.xz
82f4704c7a77c815a1c74ea62219e88d  krunner-6.15.0.tar.xz
cbcf42ddfc67cc9b1fa6e1a3c063fc51  prison-6.15.0.tar.xz
b957d3c7c10ae40d54cfdc7309cd1dce  qqc2-desktop-style-6.15.0.tar.xz
402b1966407d84186b171ee2f13270a3  kholidays-6.15.0.tar.xz
8fc28b26f4daf2a1691a9f6aca6e6602  purpose-6.15.0.tar.xz
63d804f65804d2ff50f51e36e140c0fb  kcalendarcore-6.15.0.tar.xz
d724ffc142e545b74c97ba7f348f9df9  kquickcharts-6.15.0.tar.xz
c23c7fd2f58d8d356fc28a6fe92e1e7e  knotifyconfig-6.15.0.tar.xz
43d9b041e81bad79ca06d2f1209f558a  kdav-6.15.0.tar.xz
c46a13839a3559c600c0361ef2933ccd  kstatusnotifieritem-6.15.0.tar.xz
915fac5a3052dc971d6a96326bb28a02  ksvg-6.15.0.tar.xz
6ca1e62c945513fecaa129ec7c6d1b8a  ktexttemplate-6.15.0.tar.xz
c5b33c76570142acb8346c71a01a9528  kuserfeedback-6.15.0.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')          # Remove directory
    packagedir=$(echo $pkg|sed 's|\.tar.*||') # Package directory

    name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

	PYTHON_BINDING=""

    tar -xf $file
    pushd $packagedir

      # kapidox is a python module
      case $name in
        kapidox)
			pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD
			#as_root 
			pip3 install --no-index --find-links dist --no-user kapidox
			popd
			rm -rf $packagedir
			continue
			;;
		kdbusaddons)
			unset CPLUS_INCLUDE_PATH
			;;
		kcoreaddons)
			[[ $(command -v shiboken6) == "" ]] && PYTHON_BINDING="-D BUILD_PYTHON_BINDINGS=OFF"
			;;
      esac

      mkdir build
      cd    build

      cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
            -D CMAKE_INSTALL_LIBEXECDIR=libexec \
            -D CMAKE_PREFIX_PATH=$QT6DIR        \
            -D CMAKE_SKIP_INSTALL_RPATH=ON      \
            -D CMAKE_BUILD_TYPE=Release         \
            -D BUILD_TESTING=OFF                \
			$PYTHON_BINDING -W no-dev ..
      make
      #as_root 
	  make install
    popd

  #as_root 
  rm -rf $packagedir
  #as_root 
  /sbin/ldconfig

done < frameworks-${EXT_VERSION}.md5

rm -rf $KF6_PREFIX/lib/systemd

mv -v /opt/kf6 /opt/kf6-${EXT_VERSION}
[ -h /opt/kf6 ] && unlink /opt/kf6
ln -sfvn /opt/kf6-${EXT_VERSION} /opt/kf6

update_version_list kde_framework-${EXT_VERSION}
