DESCRIPTION="KDE Frameworks is a collection of libraries based on top of Qt6 and QML derived from the previous KDE libraries."

EXT_VERSION=6.14.0

# KDE Frameworks 6 Pre-installation Configuration
#export KF6_PREFIX=/opt/kf6

source /etc/profile
export LC_ALL=C.UTF-8

if [[ $(cat /etc/profile.d/kf6.sh | grep "# Begin /etc/profile.d/kf6.sh") == "" ]]; then
cat > /etc/profile.d/kf6.sh << "EOF"
# Begin /etc/profile.d/kf6.sh

export KF6_PREFIX=/opt/kf6

pathappend $KF6_PREFIX/bin              PATH
pathappend $KF6_PREFIX/lib/pkgconfig    PKG_CONFIG_PATH

pathappend $KF6_PREFIX/etc/xdg          XDG_CONFIG_DIRS
pathappend $KF6_PREFIX/share            XDG_DATA_DIRS

pathappend $KF6_PREFIX/lib/plugins      QT_PLUGIN_PATH
pathappend $KF6_PREFIX/lib/plugins/kcms QT_PLUGIN_PATH

pathappend $KF6_PREFIX/lib/qml          QML2_IMPORT_PATH

pathappend $KF6_PREFIX/lib/python3.13/site-packages PYTHONPATH

pathappend $KF6_PREFIX/include          CPLUS_INCLUDE_PATH
# End /etc/profile.d/kf6.sh
EOF
fi

if [[ $(cat /etc/profile.d/qt6.sh | grep "# Begin Qt6 changes for KF6") == "" ]]; then
cat >> /etc/profile.d/qt6.sh << "EOF"
# Begin Qt6 changes for KF6

pathappend /usr/lib/plugins            QT_PLUGIN_PATH
pathappend $QT6DIR/plugins             QT_PLUGIN_PATH
pathappend $QT6DIR/qml                 QML2_IMPORT_PATH

# End Qt6 changes for KF6
EOF
fi

if [[ $(cat /etc/ld.so.conf | grep "/opt/kf6/lib") == "" ]]; then
cat >> /etc/ld.so.conf << "EOF"
# Begin KF6 addition

/opt/kf6/lib

# End KF6 addition
EOF
fi

[ -h $KF6_PREFIX/etc/dbus-1 ] && unlink $KF6_PREFIX/etc/dbus-1
[ -h $KF6_PREFIX/share/dbus-1 ] && unlink $KF6_PREFIX/share/dbus-1
[ -h $KF6_PREFIX/share/polkit-1 ] && unlink $KF6_PREFIX/share/polkit-1
[ -h $KF6_PREFIX/lib/systemd ] && unlink $KF6_PREFIX/lib/systemd
[ -d $KF6_PREFIX/lib/systemd ] && rm -r $KF6_PREFIX/lib/systemd

[ -h /opt/kf6 ] && unlink /opt/kf6

[ -d /opt/kf6.old ] && rm -r /opt/kf6.old

if [ -d /opt/kf6 ]; then
	mv -v /opt/kf6 /opt/kf6.old                         &&
	install -v -dm755           $KF6_PREFIX/{etc,share} &&
	ln -sfv /etc/dbus-1         $KF6_PREFIX/etc         &&
	ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share       &&
	ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share       &&
	install -v -dm755           $KF6_PREFIX/lib         &&
	ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib
fi

install -v -dm755           $KF6_PREFIX/{etc,share}
ln -sfv /etc/dbus-1         $KF6_PREFIX/etc
[ -d $KF6_PREFIX/share/dbus-1 ] && rm -r $KF6_PREFIX/share/dbus-1
ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share
ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share
install -v -dm755           $KF6_PREFIX/lib
ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib

install -v -dm755                $KF6_PREFIX/share/icons
[ -d $KF6_PREFIX/share/icons/hicolor ] && rm -r $KF6_PREFIX/share/icons/hicolor
ln -sfv /usr/share/icons/hicolor $KF6_PREFIX/share/icons

[ -h /opt/kf6-$EXT_VERSION ] && unlink /opt/kf6-$EXT_VERSION
[ -d /opt/kf6-$EXT_VERSION ] && rm -r /opt/kf6-$EXT_VERSION

#mv /opt/kf6{,-$EXT_VERSION}
#ln -sfv kf6-$EXT_VERSION /opt/kf6



url=https://download.kde.org/stable/frameworks/6.14/
wget -r -nH -nd -A '*.xz' -np $url

cat > frameworks-${EXT_VERSION}.md5 << "EOF"
165b163ab7231c7579e8333cde03e43f  attica-6.14.0.tar.xz
#0787f26f7ba5921ac665393644828843  extra-cmake-modules-6.14.0.tar.xz
ccb6639d36a854c80347491d2bf2f76f  kapidox-6.14.0.tar.xz
635d1098c7eb0571d6db43f0ff934b55  karchive-6.14.0.tar.xz
d0e8fe67e4ac9bd9f49737b5340d2766  kcodecs-6.14.0.tar.xz
84762f48c328e4e34fc4b0765829e9c7  kconfig-6.14.0.tar.xz
811a6a54570a0faee779ba6a9e01fd36  kcoreaddons-6.14.0.tar.xz
174b64417eddd97bcf954ebad7e3c784  kdbusaddons-6.14.0.tar.xz
76b0993c28f3f2e9423a459e8ec080b7  kdnssd-6.14.0.tar.xz
e00cc2feb8c55d4d864f089c33bf10c1  kguiaddons-6.14.0.tar.xz
6516d15a1e34e4caef35d69607a95663  ki18n-6.14.0.tar.xz
0a9a1c022909d4be6d9fb310ede1ebe6  kidletime-6.14.0.tar.xz
00f8aeb62b6ca6c7011e56cf136aa668  kimageformats-6.14.0.tar.xz
ea2ab0d7af7a70b95cb347b989bdad92  kitemmodels-6.14.0.tar.xz
87ba844368f4590b1fbdeac4227a9cae  kitemviews-6.14.0.tar.xz
fa4eaadde19a5bfe8407182764a25092  kplotting-6.14.0.tar.xz
366bf57822d020c18acfc8f63bb53f83  kwidgetsaddons-6.14.0.tar.xz
bd6b50cdfa4aa40abd607df7bf3ae4aa  kwindowsystem-6.14.0.tar.xz
6eda7f687ea9314424250bdf765e2d52  networkmanager-qt-6.14.0.tar.xz
b2fa74433e5e5e0d17b11a537ae41065  solid-6.14.0.tar.xz
13c0e8170ddee46d653b823253ef6d8e  sonnet-6.14.0.tar.xz
5f3567dae998ca69fb8faa1d1ea68d10  threadweaver-6.14.0.tar.xz
c04d4e01cc1fe0887e141c5c1c2bf404  kauth-6.14.0.tar.xz
4b60cb0247130a5a24300602d76f8949  kcompletion-6.14.0.tar.xz
d5a2404c2758121d1c4e4a2c925f3377  kcrash-6.14.0.tar.xz
c0dcccda17da7f0cd91825cdb118329c  kdoctools-6.14.0.tar.xz
8ceea0f0cec2302e129ff9ae083d5ffd  kpty-6.14.0.tar.xz
57f619d9ccf7ce3ffb0d93d266d859f7  kunitconversion-6.14.0.tar.xz
617ffe585b74182c6f9a0027d5697901  kcolorscheme-6.14.0.tar.xz
88b6095c098d17133fc232a1659d19aa  kconfigwidgets-6.14.0.tar.xz
70abb8a3d32edf9857e4737ece175203  kservice-6.14.0.tar.xz
67c39da521e6c210c10f44ae75863280  kglobalaccel-6.14.0.tar.xz
7118b11f803789752c1a75950ecdb38d  kpackage-6.14.0.tar.xz
3a82ad4d22a4093f21cd307ac6bdd2fd  kdesu-6.14.0.tar.xz
72b42af34f39df0d67a3511f03fbff89  kiconthemes-6.14.0.tar.xz
622456f274b76ac109d89be325ce3ff4  knotifications-6.14.0.tar.xz
0ba764fd88af1496c7912e9389b75a75  kjobwidgets-6.14.0.tar.xz
0ce0016f7fdebd1b713dd65718e35c6e  ktextwidgets-6.14.0.tar.xz
ad0c09af97b5af01212a2240b5be6644  kxmlgui-6.14.0.tar.xz
e3fa434a1a03b9078adcb81bfc767fa4  kbookmarks-6.14.0.tar.xz
#5b399f3c9bbeabc0d434ee553c34e3f1  kwallet-6.14.0.tar.xz
530b1253870e37f75a4af218cf889009  kwallet-6.14.1.tar.xz
428d0e0fa19edbfcb7a5e320d36e412f  kded-6.14.0.tar.xz
cc0bd4a38d4b9b6080f8e11c22c634df  kio-6.14.0.tar.xz
28909eaeb864dbf762ceac989e9da424  kdeclarative-6.14.0.tar.xz
b6a713ea7a86a4b4ba9f7c26c88ffb52  kcmutils-6.14.0.tar.xz
#120b16d889b47e2ca1327c3cab9d35b7  kirigami-6.14.0.tar.xz
0dc8ea23799490bbf90fb7bb8f4f72dc  kirigami-6.14.1.tar.xz
c1d0267acf6c72829a5ed6ac7e49152c  syndication-6.14.0.tar.xz
b3d81b1c184b127d677119f7a7282f79  knewstuff-6.14.0.tar.xz
64b921db085ff48276e6ee8da45d582f  frameworkintegration-6.14.0.tar.xz
6a6b11193703838208b96bf11bd22259  kparts-6.14.0.tar.xz
aba286f4bf7de433e096eb3458e847bb  syntax-highlighting-6.14.0.tar.xz
db2c03bb09b44aed962f8497651d0748  ktexteditor-6.14.0.tar.xz
7d430d7a3f90864cd2ca86b57d1706b8  modemmanager-qt-6.14.0.tar.xz
0b6db4db21e997fc14ca177d8f62e0b8  kcontacts-6.14.0.tar.xz
25aa937b849fd9ae69932c41b17d6bf5  kpeople-6.14.0.tar.xz
b24408cbba6eacebd5d399185d3ee77c  bluez-qt-6.14.0.tar.xz
ca2ed78578d1ac4cddaa283f3a7ba8f4  kfilemetadata-6.14.0.tar.xz
9b13e46068bda372c5abc118e141316c  baloo-6.14.0.tar.xz
#b132c475a7e389e6f7d36323279a7f3d  breeze-icons-6.14.0.tar.xz
a435b2ac9c5bc4dff5cd5b8ad38653a3  krunner-6.14.0.tar.xz
3c30dc5e69ebfd30f06de00a9e54f902  prison-6.14.0.tar.xz
6d7743494d896980884e2c1e8d1d1ebf  qqc2-desktop-style-6.14.0.tar.xz
7c445704ee24d5755714eaf86ea340ea  kholidays-6.14.0.tar.xz
a19adf09478daf3e6fcd7bafee1f3a8f  purpose-6.14.0.tar.xz
cbd3ae04c0b2093c414f908daa4589bf  kcalendarcore-6.14.0.tar.xz
e955da56de5606fd74cab7eacc4576e8  kquickcharts-6.14.0.tar.xz
56c871dd8b59d1211feabb2da8087e42  knotifyconfig-6.14.0.tar.xz
692b832a4d11c83f4c6ec0868c91effb  kdav-6.14.0.tar.xz
80f2ea5c5b6901c3415a64d5ee0429b2  kstatusnotifieritem-6.14.0.tar.xz
e0e6deb2ef044df77dbc848002bf60aa  ksvg-6.14.0.tar.xz
7e1542d5a1ba7ab659a6a334425a4df9  ktexttemplate-6.14.0.tar.xz
975214cc75bfadb9464174f78f1548ba  kuserfeedback-6.14.0.tar.xz
EOF

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')          # Remove directory
    packagedir=$(echo $pkg|sed 's|\.tar.*||') # Package directory

    name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

    tar -xf $file
    pushd $packagedir

      # kapidox is a python module
      case $name in
        kapidox)
          pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD
          #as_root 
		  pip3 install --no-index --find-links dist --no-user kapidox
          popd
          rm -rf $packagedir
          continue
          ;;
		kdbusaddons)
          unset CPLUS_INCLUDE_PATH
          ;;
      esac

      mkdir build
      cd    build

      cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
            -D CMAKE_INSTALL_LIBEXECDIR=libexec \
            -D CMAKE_PREFIX_PATH=$QT6DIR        \
            -D CMAKE_SKIP_INSTALL_RPATH=ON      \
            -D CMAKE_BUILD_TYPE=Release         \
            -D BUILD_TESTING=OFF                \
            -W no-dev ..
      make
      #as_root 
	  make install
    popd

  #as_root 
  rm -rf $packagedir
  #as_root 
  /sbin/ldconfig

done < frameworks-${EXT_VERSION}.md5

rm -rf $KF6_PREFIX/lib/systemd

mv -v /opt/kf6 /opt/kf6-${EXT_VERSION}
[ -h /opt/kf6 ] && unlink /opt/kf6
ln -sfvn /opt/kf6-${EXT_VERSION} /opt/kf6

update_version_list kde_framework-${EXT_VERSION}
