DESCRIPTION="KDE Frameworks is a collection of libraries based on top of Qt6 and QML derived from the previous KDE libraries."

EXT_VERSION=6.13.0

# KDE Frameworks 6 Pre-installation Configuration
#export KF6_PREFIX=/opt/kf6

source /etc/profile
export LC_ALL=C.UTF-8

if [[ $(cat /etc/profile.d/kf6.sh | grep "# Begin /etc/profile.d/kf6.sh") == "" ]]; then
cat > /etc/profile.d/kf6.sh << "EOF"
# Begin /etc/profile.d/kf6.sh

export KF6_PREFIX=/opt/kf6

pathappend $KF6_PREFIX/bin              PATH
pathappend $KF6_PREFIX/lib/pkgconfig    PKG_CONFIG_PATH

pathappend $KF6_PREFIX/etc/xdg          XDG_CONFIG_DIRS
pathappend $KF6_PREFIX/share            XDG_DATA_DIRS

pathappend $KF6_PREFIX/lib/plugins      QT_PLUGIN_PATH
pathappend $KF6_PREFIX/lib/plugins/kcms QT_PLUGIN_PATH

pathappend $KF6_PREFIX/lib/qml          QML2_IMPORT_PATH

pathappend $KF6_PREFIX/lib/python3.13/site-packages PYTHONPATH

pathappend $KF6_PREFIX/include          CPLUS_INCLUDE_PATH
# End /etc/profile.d/kf6.sh
EOF
fi

if [[ $(cat /etc/profile.d/qt6.sh | grep "# Begin Qt6 changes for KF6") == "" ]]; then
cat >> /etc/profile.d/qt6.sh << "EOF"
# Begin Qt6 changes for KF6

pathappend /usr/lib/plugins            QT_PLUGIN_PATH
pathappend $QT6DIR/plugins             QT_PLUGIN_PATH
pathappend $QT6DIR/qml                 QML2_IMPORT_PATH

# End Qt6 changes for KF6
EOF
fi

if [[ $(cat /etc/ld.so.conf | grep "/opt/kf6/lib") == "" ]]; then
cat >> /etc/ld.so.conf << "EOF"
# Begin KF6 addition

/opt/kf6/lib

# End KF6 addition
EOF
fi

[ -h $KF6_PREFIX/etc/dbus-1 ] && unlink $KF6_PREFIX/etc/dbus-1
[ -h $KF6_PREFIX/share/dbus-1 ] && unlink $KF6_PREFIX/share/dbus-1
[ -h $KF6_PREFIX/share/polkit-1 ] && unlink $KF6_PREFIX/share/polkit-1
[ -h $KF6_PREFIX/lib/systemd ] && unlink $KF6_PREFIX/lib/systemd

install -v -dm755           $KF6_PREFIX/{etc,share}
ln -sfv /etc/dbus-1         $KF6_PREFIX/etc
[ -d $KF6_PREFIX/share/dbus-1 ] && rm -r $KF6_PREFIX/share/dbus-1
ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share
ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share
install -v -dm755           $KF6_PREFIX/lib
ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib

install -v -dm755                $KF6_PREFIX/share/icons
[ -d $KF6_PREFIX/share/icons/hicolor ] && rm -r $KF6_PREFIX/share/icons/hicolor
ln -sfv /usr/share/icons/hicolor $KF6_PREFIX/share/icons

[ -h /opt/kf6-$EXT_VERSION ] && unlink /opt/kf6-$EXT_VERSION
[ -d /opt/kf6-$EXT_VERSION ] && rm -r /opt/kf6-$EXT_VERSION

#mv /opt/kf6{,-$EXT_VERSION}
#ln -sfv kf6-$EXT_VERSION /opt/kf6



url=https://download.kde.org/stable/frameworks/6.13/
wget -r -nH -nd -A '*.xz' -np $url

cat > frameworks-${EXT_VERSION}.md5 << "EOF"
c12ac706d1f5b1cde0b65c7f8d74288f  attica-6.13.0.tar.xz
#fffa4105250ef446219808e275c754a5  extra-cmake-modules-6.13.0.tar.xz
9adefdfc46c805f55f2c2736d118f5a5  kapidox-6.13.0.tar.xz
8c54e968cd52480bb5c7dc5dd262bba6  karchive-6.13.0.tar.xz
f8fe4baf7745a75028a4d063aadb768c  kcodecs-6.13.0.tar.xz
eeb0d97e29b84f9f58977e90d24f23ee  kconfig-6.13.0.tar.xz
42ea67c66d76712a359df6b6a4d271c1  kcoreaddons-6.13.0.tar.xz
dd53aa26b08bb275f17503959815bde2  kdbusaddons-6.13.0.tar.xz
0276c48fe10629c5f97efc46444a2201  kdnssd-6.13.0.tar.xz
0b00b7489887eee35c0f105d65a8b4ed  kguiaddons-6.13.0.tar.xz
bcc51ec7d2dfaa68465947e54babf61e  ki18n-6.13.0.tar.xz
89b25fac6b75ced80c9fbb8189412e0d  kidletime-6.13.0.tar.xz
ba7a2ca96b4df6025619bd58f452b4e6  kimageformats-6.13.0.tar.xz
c6d84368fa1476c1be44ea8f8e80bb4a  kitemmodels-6.13.0.tar.xz
70089619a94a0e81264c8d487e7251e0  kitemviews-6.13.0.tar.xz
be1f5afd4ac09d2361ed0162d872e970  kplotting-6.13.0.tar.xz
8b7586ba8a39718b261b8626d0dbf8ef  kwidgetsaddons-6.13.0.tar.xz
9ff25f2b5a06c4531efb01ae5c5d7deb  kwindowsystem-6.13.0.tar.xz
7fe8caa8f457ed9ff2e3441681ee39a8  networkmanager-qt-6.13.0.tar.xz
3e03e17c5d4ed73fda022e5d022a5634  solid-6.13.0.tar.xz
086d95b6c3ca5662da495a20e70d1046  sonnet-6.13.0.tar.xz
8b661df05c7f2c81cda0560dd4a45e34  threadweaver-6.13.0.tar.xz
2a58610e2d92e94c26d4e5bcd099d653  kauth-6.13.0.tar.xz
41c89f6e166a810fdcbe2ea9a0235822  kcompletion-6.13.0.tar.xz
1d4c0b59d2706a4cc953ebb3097f2493  kcrash-6.13.0.tar.xz
34fd06a35b7ae7e4ae8a95848b057d2e  kdoctools-6.13.0.tar.xz
5639de35d027d25d5c2537049fa8e1ef  kpty-6.13.0.tar.xz
dc9f9408462a03b232c6492a5c08ddea  kunitconversion-6.13.0.tar.xz
c02d1db1cc46785a786603d3e262a5aa  kcolorscheme-6.13.0.tar.xz
60ee97fd70d698e8e5318a4f82eb3bb4  kconfigwidgets-6.13.0.tar.xz
7b1616897f802d98b7432edf604285bb  kservice-6.13.0.tar.xz
487332e4e629411e4ebfd6c4ee65c93b  kglobalaccel-6.13.0.tar.xz
b7a158ee246a694296193f2fdad0a75c  kpackage-6.13.0.tar.xz
2ba3e12c09523a06fd9c7c41f61276bc  kdesu-6.13.0.tar.xz
6982b13fb92ae3792eb16aefd5980088  kiconthemes-6.13.0.tar.xz
3a06c30f46d48292bbe65bcbde3ea175  knotifications-6.13.0.tar.xz
d1d0caa9fe35d2c34d15d448dc1022ee  kjobwidgets-6.13.0.tar.xz
1e8f264d42649f8a3288742ed2a757a1  ktextwidgets-6.13.0.tar.xz
e722e89631cbaa69a206551a8a66dbd3  kxmlgui-6.13.0.tar.xz
0e9fcbf3f244f3e66d150cf78acfd452  kbookmarks-6.13.0.tar.xz
6d40ad91d72406c3e8b1d55655cc35f0  kwallet-6.13.0.tar.xz
472202ec46a6c0b4a838b6143d6a0d60  kded-6.13.0.tar.xz
632f38fc7601e22dc231793d902c6292  kio-6.13.0.tar.xz
0b76489ddb1c86ba0a9d5abdee0022a4  kdeclarative-6.13.0.tar.xz
45e133f0a42359578160331ac0e2a26c  kcmutils-6.13.0.tar.xz
9659239b81fd0266fbec52eddeaa6029  kirigami-6.13.0.tar.xz
d1bcb046907203a9ad484a269c4aee81  syndication-6.13.0.tar.xz
af414da3f21e43288d8ca394477c0c73  knewstuff-6.13.0.tar.xz
f7f9cd13902679ef605eb76293bcf6b9  frameworkintegration-6.13.0.tar.xz
c45e7383a99b52e2e1ae2307b51acd06  kparts-6.13.0.tar.xz
ba7c5298c3f81f21d30f591b3d4f4859  syntax-highlighting-6.13.0.tar.xz
bcc08aa21ba552bbefe2a8c97d4027e3  ktexteditor-6.13.0.tar.xz
fd872dfb6c662475972b2cab44cad03d  modemmanager-qt-6.13.0.tar.xz
b723cd0d7991dcab82b59ef2b6cc65d8  kcontacts-6.13.0.tar.xz
2b2c2fd028cbc4256ecae04362d1f304  kpeople-6.13.0.tar.xz
756838cb9d946e06ac8fb6cb9fde57dc  bluez-qt-6.13.0.tar.xz
45779ed91f44700ff9d80082bb1c3843  kfilemetadata-6.13.0.tar.xz
c23b73568aeee9aa5f9afec7def9e15d  baloo-6.13.0.tar.xz
#48fc3036c91eed1fd8d89efb83d9494c  breeze-icons-6.13.0.tar.xz
36ff81ebcdb1988eb272bf27f0dfc035  krunner-6.13.0.tar.xz
##ca5266e18d3d15c089031a896401421e  prison-6.13.0.tar.xz
6ea9727a9a2968f03da3e5e3d549eed3  qqc2-desktop-style-6.13.0.tar.xz
4233fd805137aa1a8c8faf2c8b5d71a0  kholidays-6.13.0.tar.xz
02b90cd4bbed0a86e3eb1c66ea0cb0ec  purpose-6.13.0.tar.xz
0b19cdb1039bd146c45a6d5cc7099e60  kcalendarcore-6.13.0.tar.xz
9727025fec963329082c5d29bfd85b23  kquickcharts-6.13.0.tar.xz
6e2ba94485d3773e4b21645d131646e3  knotifyconfig-6.13.0.tar.xz
5729859a76b5feecc9a115bd6dad91b3  kdav-6.13.0.tar.xz
c8475b31a270bd47a8f10e4d383af7d6  kstatusnotifieritem-6.13.0.tar.xz
dd3f65c9d10991d7fded37c9d51fb956  ksvg-6.13.0.tar.xz
61d5d199dacd67a4689137634ae171d8  ktexttemplate-6.13.0.tar.xz
3a9e9345e06be417fb087d3fc1274181  kuserfeedback-6.13.0.tar.xz
EOF

[ -h /opt/kf6 ] && unlink /opt/kf6

[ -d /opt/kf6.old ] && rm -r /opt/kf6.old

if [ -d /opt/kf6 ]; then
	mv -v /opt/kf6 /opt/kf6.old                         &&
	install -v -dm755           $KF6_PREFIX/{etc,share} &&
	ln -sfv /etc/dbus-1         $KF6_PREFIX/etc         &&
	ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share       &&
	ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share       &&
	install -v -dm755           $KF6_PREFIX/lib         &&
	ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib
fi

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')          # Remove directory
    packagedir=$(echo $pkg|sed 's|\.tar.*||') # Package directory

    name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

    tar -xf $file
    pushd $packagedir

      # kapidox is a python module
      case $name in
        kapidox)
          pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD
          #as_root 
		  pip3 install --no-index --find-links dist --no-user kapidox
          popd
          rm -rf $packagedir
          continue
          ;;
		kdbusaddons)
          unset CPLUS_INCLUDE_PATH
          ;;
      esac

      mkdir build
      cd    build

      cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
            -D CMAKE_INSTALL_LIBEXECDIR=libexec \
            -D CMAKE_PREFIX_PATH=$QT6DIR        \
            -D CMAKE_SKIP_INSTALL_RPATH=ON      \
            -D CMAKE_BUILD_TYPE=Release         \
            -D BUILD_TESTING=OFF                \
            -W no-dev ..
      make
      #as_root 
	  make install
    popd

  #as_root 
  rm -rf $packagedir
  #as_root 
  /sbin/ldconfig

done < frameworks-${EXT_VERSION}.md5

rm -rf $KF6_PREFIX/lib/systemd

mv -v /opt/kf6 /opt/kf6-${EXT_VERSION}
ln -sfvn kf6-${EXT_VERSION} /opt/kf6

update_version_list kde_framework-${EXT_VERSION}
