DESCRIPTION="KDE Frameworks is a collection of libraries based on top of Qt6 and QML derived from the previous KDE libraries."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_BLANK .tar.gz | cut -d "-" -f 2) 

# KDE Frameworks 6 Pre-installation Configuration
#export KF6_PREFIX=/opt/kf6

#export LC_ALL=C.UTF-8

cat > /etc/profile.d/kf6.sh << "EOF"
# Begin /etc/profile.d/kf6.sh

export KF6_PREFIX=/opt/kf6

pathappend $KF6_PREFIX/bin              PATH
pathappend $KF6_PREFIX/lib/pkgconfig    PKG_CONFIG_PATH

pathappend $KF6_PREFIX/etc/xdg          XDG_CONFIG_DIRS
pathappend $KF6_PREFIX/share            XDG_DATA_DIRS

pathappend $KF6_PREFIX/lib/plugins      QT_PLUGIN_PATH
pathappend $KF6_PREFIX/lib/plugins/kcms QT_PLUGIN_PATH

pathappend $KF6_PREFIX/lib/qml          QML2_IMPORT_PATH

pathappend $KF6_PREFIX/lib/python3.13/site-packages PYTHONPATH

pathappend $KF6_PREFIX/include          CPLUS_INCLUDE_PATH
# End /etc/profile.d/kf6.sh
EOF

cat >> /etc/profile.d/qt6.sh << "EOF"
# Begin Qt6 changes for KF6

pathappend /usr/lib/plugins            QT_PLUGIN_PATH
pathappend $QT6DIR/plugins             QT_PLUGIN_PATH
pathappend $QT6DIR/qml                 QML2_IMPORT_PATH

# End Qt6 changes for KF6
EOF

cat >> /etc/ld.so.conf << "EOF"
# Begin KF6 addition

/opt/kf6/lib

# End KF6 addition
EOF

[ -h $KF6_PREFIX/etc/dbus-1 ] && unlink $KF6_PREFIX/etc/dbus-1
[ -h $KF6_PREFIX/share/dbus-1 ] && unlink $KF6_PREFIX/share/dbus-1
[ -h $KF6_PREFIX/share/polkit-1 ] && unlink $KF6_PREFIX/share/polkit-1
[ -h $KF6_PREFIX/lib/systemd ] && unlink $KF6_PREFIX/lib/systemd

install -v -dm755           $KF6_PREFIX/{etc,share}
ln -sfv /etc/dbus-1         $KF6_PREFIX/etc
[ -d $KF6_PREFIX/share/dbus-1 ] && rm -r $KF6_PREFIX/share/dbus-1
ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share
ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share
install -v -dm755           $KF6_PREFIX/lib
ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib

install -v -dm755                $KF6_PREFIX/share/icons
ln -sfv /usr/share/icons/hicolor $KF6_PREFIX/share/icons

[ -h /opt/kf6-6.11.0 ] && unlink /opt/kf6-6.11.0
[ -d /opt/kf6-6.11.0 ] && rm -r /opt/kf6-6.11.0

mv /opt/kf6{,-6.11.0}
ln -sfv kf6-6.11.0 /opt/kf6



url=https://download.kde.org/stable/frameworks/6.11/
wget -r -nH -nd -A '*.xz' -np $url

cat > frameworks-6.11.0.md5 << "EOF"
9359cfb89031abeeff8616d73e161415  attica-6.11.0.tar.xz
#22bce8bd85c1ead07bda8a00518d1120  extra-cmake-modules-6.11.0.tar.xz
647b2f9cfd55930e86ebb8c1734df140  kapidox-6.11.0.tar.xz
20c3fbf44d196d578bf9b76d0631a1ad  karchive-6.11.0.tar.xz
4b4af41ab285dda00a660b34e21e2f8c  kcodecs-6.11.0.tar.xz
b0e4142ee55abf3cb38fe6cdf5a0fe71  kconfig-6.11.0.tar.xz
6fa75ef6c2e9ce2fc9b7fb7f77e8db53  kcoreaddons-6.11.0.tar.xz
2ee71003f7887b6ac6646abd134e23ba  kdbusaddons-6.11.0.tar.xz
ead6114916c7aa01a8f6c3965315e9ec  kdnssd-6.11.0.tar.xz
7679bb9a2a0e817f9660ec775f93dc04  kguiaddons-6.11.0.tar.xz
27a6809407ea64c9db9bbb595cfe1282  ki18n-6.11.0.tar.xz
16d30e56e423668c27bfcbd2425a19da  kidletime-6.11.0.tar.xz
4f035f9b0466e297bd95ee57eb53f820  kimageformats-6.11.0.tar.xz
7e48fb5e56bcedff3281d64115d85699  kitemmodels-6.11.0.tar.xz
df934558aaa739a50b16677a3cdc97f7  kitemviews-6.11.0.tar.xz
cbe17f3ad215492a6d3d60d1b161a056  kplotting-6.11.0.tar.xz
85234f0053b4cf6ac5492ba92db2d648  kwidgetsaddons-6.11.0.tar.xz
0fe4524579013c8e9fcf7adf43ea844e  kwindowsystem-6.11.0.tar.xz
72fbceb5e5b990d501a1ba3684c78ad0  networkmanager-qt-6.11.0.tar.xz
05d5c3b1277129f4e5fa1e3db9077e10  solid-6.11.0.tar.xz
cc92475aacad8a29de2029e6483ff0b2  sonnet-6.11.0.tar.xz
5236898e85ea7b2b8124ffe21e2e8a51  threadweaver-6.11.0.tar.xz
efe35421eb54433599bb5724bd4b2312  kauth-6.11.0.tar.xz
33067f4f53c2e0e0da9d1324f01af19a  kcompletion-6.11.0.tar.xz
1562644115cb4a3d8f5e847c196a6e1b  kcrash-6.11.0.tar.xz
52d5e6b18613fd23ba09d05459812062  kdoctools-6.11.0.tar.xz
0cadf6b126b5ed62393b99146bbdaec9  kpty-6.11.0.tar.xz
6d306e6f78769cb8405f909e26db3d76  kunitconversion-6.11.0.tar.xz
b0a6afbdee57b249771017be13b5e9cf  kcolorscheme-6.11.0.tar.xz
b2c09a5d3fdcfa3c7fc88617590ac694  kconfigwidgets-6.11.0.tar.xz
71abec8311c27c7b3f8652da220011b8  kservice-6.11.0.tar.xz
357c4a01badb564c4a66ce3503bb7493  kglobalaccel-6.11.0.tar.xz
772720c4f1b51589abd1964750ef96e6  kpackage-6.11.0.tar.xz
6de72206275db095889d5ef02ecfeaae  kdesu-6.11.0.tar.xz
f7c14bb2f32943060553c517956bcd36  kiconthemes-6.11.0.tar.xz
3a502ab55f0ca2f1a5e5ab69de951932  knotifications-6.11.0.tar.xz
e3056aadf29ca9a09f015632f5c851d8  kjobwidgets-6.11.0.tar.xz
fe6ac2b10dcadad94e2b54dfd8788fc1  ktextwidgets-6.11.0.tar.xz
cbecf5de939fa3c2340abf4c1c34a550  kxmlgui-6.11.0.tar.xz
83d780dba76ffdb59b119513a94cfaa0  kbookmarks-6.11.0.tar.xz
c69002e34487b8182a7b248265846a8f  kwallet-6.11.0.tar.xz
e68dc289e81b20bf781ca7920133ae37  kded-6.11.0.tar.xz
76a597b191d8a1ff103dec70137635a7  kio-6.11.0.tar.xz
092619893a0c6e0e9e735e2396f9518b  kdeclarative-6.11.0.tar.xz
90434f367fce9f8ea1cfaccc4642efef  kcmutils-6.11.0.tar.xz
c12b36fecb8f26b48d793fe7e3a29405  kirigami-6.11.0.tar.xz
3227ac57ecdaed4c0d4c6b6b48b81ac4  syndication-6.11.0.tar.xz
096b9d761ee2997f34de83a9cee5062d  knewstuff-6.11.0.tar.xz
e5ba9f692c12dc7f3f4e2291aca802d7  frameworkintegration-6.11.0.tar.xz
138bf9e51cadd7381a9de428345c78c2  kparts-6.11.0.tar.xz
f75164871c6e7594f81c71d0849f90d3  syntax-highlighting-6.11.0.tar.xz
5ece9440ecedae18706884501e8deae4  ktexteditor-6.11.0.tar.xz
cc4b04c3c42a54259d704534b083f991  modemmanager-qt-6.11.0.tar.xz
fb993807e86e8f1679a6ea59aed71c1e  kcontacts-6.11.0.tar.xz
1545793a6da6d4b67f42959dc49d4cef  kpeople-6.11.0.tar.xz
e55224a99439e7bb1abf7eab2cd2ef75  bluez-qt-6.11.0.tar.xz
43e1dba98100aebf27297815a0fb8296  kfilemetadata-6.11.0.tar.xz
5e4b41a45872794d45038ca66125cbf8  baloo-6.11.0.tar.xz
#8989043ad5c6bae49cb2abb3e88490aa  breeze-icons-6.11.0.tar.xz
d336f55f2747377d0b8f388263749fe4  krunner-6.11.0.tar.xz
5291071632d3296b6d1201622fe1f54e  prison-6.11.0.tar.xz
eb72c496e3e6ba0ea66aa96a81683491  qqc2-desktop-style-6.11.0.tar.xz
89a6c13f89e6ac7ae5cd36c28ea51ba4  kholidays-6.11.0.tar.xz
0f72d877a62f5697c08c3649d0dc61cc  purpose-6.11.0.tar.xz
268c7ca1ba88d7cd544914760d1862a6  kcalendarcore-6.11.0.tar.xz
3b5c13512812315c913e936d8c14298d  kquickcharts-6.11.0.tar.xz
29c0bab2e75f093cbfb1630f349959a3  knotifyconfig-6.11.0.tar.xz
eb41b80c24a0768b915dab171d3db5c3  kdav-6.11.0.tar.xz
56e50e418a25fd981a11553f0e313800  kstatusnotifieritem-6.11.0.tar.xz
1e757bef30a30391eafe34ac06b5d281  ksvg-6.11.0.tar.xz
cdb940239552ee0c70fab32f496bc592  ktexttemplate-6.11.0.tar.xz
ee50bf09b87548e416b60826b6086041  kuserfeedback-6.11.0.tar.xz
EOF

[ -h /opt/kf6 ] && unlink /opt/kf6

[ -d /opt/kf6.old ] && rm -r /opt/kf6.old

if [ -d /opt/kf6 ]; then
	mv -v /opt/kf6 /opt/kf6.old                         &&
	install -v -dm755           $KF6_PREFIX/{etc,share} &&
	ln -sfv /etc/dbus-1         $KF6_PREFIX/etc         &&
	ln -sfv /usr/share/dbus-1   $KF6_PREFIX/share       &&
	ln -sfv /usr/share/polkit-1 $KF6_PREFIX/share       &&
	install -v -dm755           $KF6_PREFIX/lib         &&
	ln -sfv /usr/lib/systemd    $KF6_PREFIX/lib
fi

while read -r line; do

    # Get the file name, ignoring comments and blank lines
    if $(echo $line | grep -E -q '^ *$|^#' ); then continue; fi
    file=$(echo $line | cut -d" " -f2)

    pkg=$(echo $file|sed 's|^.*/||')          # Remove directory
    packagedir=$(echo $pkg|sed 's|\.tar.*||') # Package directory

    name=$(echo $pkg|sed 's|-6.*$||') # Isolate package name

    tar -xf $file
    pushd $packagedir

      # kapidox is a python module
      case $name in
        kapidox)
          pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD
          #as_root 
		  pip3 install --no-index --find-links dist --no-user kapidox
          popd
          rm -rf $packagedir
          continue
          ;;
      esac

      mkdir build
      cd    build

      cmake -D CMAKE_INSTALL_PREFIX=$KF6_PREFIX \
            -D CMAKE_INSTALL_LIBEXECDIR=libexec \
            -D CMAKE_PREFIX_PATH=$QT6DIR        \
            -D CMAKE_SKIP_INSTALL_RPATH=ON      \
            -D CMAKE_BUILD_TYPE=Release         \
            -D BUILD_TESTING=OFF                \
            -W no-dev ..
      make
      #as_root 
	  make install
    popd

  #as_root 
  rm -rf $packagedir
  #as_root 
  /sbin/ldconfig

done < frameworks-6.11.0.md5

mv -v /opt/kf6 /opt/kf6-6.11.0
ln -sfvn kf6-6.11.0 /opt/kf6

update_version_list kde_framework-6.11.0
