echo "# $EXTENSION/build_order.txt" 				 	 > $EXTENSION/build_order.txt
echo "# <scriptname> (without .sh)" 					>> $EXTENSION/build_order.txt
echo "" 												>> $EXTENSION/build_order.txt

#export KF6_PREFIX=/usr
export KF6_PREFIX=/opt/kf6
#export QT6DIR=$KF6_PREFIX

# Required
[[ ! -f /etc/profile.d/xorg.sh ]] && echo "Installing xorg_build_env" && extension --install xorg_build_env && echo "Finished xorg_build_env"
source /etc/profile.d/xorg.sh

[[ $(cat /usr/share/ECM/cmake/ECMConfigVersion.cmake | grep "6.11.0") == "" ]] && echo "Installing extra_cmake_modules:6.11.0" && extension --install extra_cmake_modules:6.11.0 && echo "Finished extra_cmake_modules:6.11.0"
[ ! -d /usr/share/icons/breeze ] && echo "Installing kde_breeze_icons" && extension --install kde_breeze_icons && echo "Finished kde_breeze_icons"
[ ! -d /etc/xml ] && echo "Installing docbook4_xml" && extension --install docbook4_xml && echo "Finished docbook4_xml"
[ ! -d /usr/share/xml/docbook/xsl-stylesheets-nons-* ] && echo "Installing docbook_xsl_nons" && extension --install docbook_xsl_nons && echo "Finished docbook_xsl_nons"
[[ $(command -v canberra-gtk-play) == "" ]] && echo "Installing libcanberra" && extension --install libcanberra && echo "Finished libcanberra"
[[ $(command -v hmac256) == "" ]] && echo "Installing libgcrypt" && extension --install libgcrypt && echo "Finished libgcrypt"
[ ! -f /lib/libical.so ] && echo "Installing libical" && extension --install libical && echo "Finished libical"
[[ $(command -v xsltproc) == "" ]] && echo "Installing libxslt" && extension --install libxslt && echo "Finished libxslt"
[[ $(command -v mdb_stat) == "" ]] && echo "Installing lmdb" && extension --install lmdb && echo "Finished lmdb"
[[ $(command -v qcatool-qt6) == "" ]] && echo "Installing qca" && extension --install qca && echo "Finished qca"
[[ $(command -v qrencode) == "" ]] && echo "Installing qrencode" && extension --install qrencode && echo "Finished qrencode"
[ ! -d /usr/share/plasma-wayland-protocols ] && echo "Installing plasma_wayland_protocols" && extension --install plasma_wayland_protocols && echo "Finished plasma_wayland_protocols"
[ ! -d /usr/lib/python*/site-packages/pyyaml-* ] && echo "Installing py_pyyaml" && extension --install py_pyyaml && echo "Finished py_pyyaml"
[[ $(command -v update-mime-database) == "" ]] && echo "Installing shared_mime_info" && extension --install shared_mime_info && echo "Finished shared_mime_info"
[ ! -f  /usr/lib/perl5/*/site_perl/URI.pm ] && echo "Installing perl_uri" && extension --install perl_uri && echo "Finished perl_uri"
[[ $(command -v wget) == "" ]] && echo "Installing wget" && extension --install wget && echo "Finished wget"

# Recommended
if [[ $INSTALL_RECOMMENDED != false ]]; then 
	# Aspell-0.60.8.1 (Dictionary backend for Sonnet), Avahi-0.8 (DNS-SD backend for KDNSSD), ModemManager-1.18.12 (needed to build ModemManager-Qt), NetworkManager-1.50.0 (needed to build NetworkManager-Qt), polkit-qt-0.200.0 (Authentication backend for KAuth), Vulkan-Loader-1.4.304 (Add support for Vulkan graphics drivers), and zxing-cpp-2.3.0 (Add support needed to build spectacle)
	[[ $(command -v aspell) == "" ]] && echo "Installing aspell" && extension --install aspell && echo "Finished aspell"
	[[ $(command -v avahi-daemon) == "" ]] && echo "Installing avahi" && extension --install avahi && echo "Finished avahi"
	[[ $(command -v ModemManager) == "" ]] && echo "Installing modemmanager" && extension --install modemmanager && echo "Finished modemmanager"
	[[ $(command -v NetworkManager) == "" ]] && echo "Installing networkmanager" && extension --install networkmanager && echo "Finished networkmanager"
	[ ! -f /lib/libpolkit-qt6-core-1.so ] && echo "Installing polkit_qt" && extension --install polkit_qt && echo "Finished polkit_qt"
	[ ! -f /lib/libvulkan.so ] && echo "Installing vulkan_loader" && extension --install vulkan_loader && echo "Finished vulkan_loader"
	[ ! -f /lib/libZXing.so ] && echo "Installing zxing_cpp" && extension --install zxing_cpp && echo "Finished zxing_cpp"
fi

# Furthermore, the instructions below assume that the environment has been set up as described in Introduction to KF6.

# Optional
if [[ $INSTALL_OPTIONAL != false ]]; then 
	# BlueZ-5.79 (needed to build Bluez-Qt) and Datamatrix (deemed recommended for Prison by upstream)
	[[ $(command -v btmon) == "" ]] && echo "Installing bluez" && extension --install bluez && echo "Finished bluez"
fi

# Runtime dependency for FrameworkIntegration
# Noto fonts

# Additional recommended dependencies for kapidox
if [[ $INSTALL_RECOMMENDED != false ]]; then 
	# Doxygen-1.13.2 (Run time), doxypypy-0.8.8.7, doxyqml-0.5.3, and requests-2.32.3
	[[ $(command -v doxygen) == "" ]] && echo "Installing doxygen" && extension --install doxygen && echo "Finished doxygen"
	[[ $(command -v doxypypy) == "" ]] && echo "Installing py_doxypypy" && extension --install py_doxypypy && echo "Finished py_doxypypy"
	[[ $(command -v doxyqml) == "" ]] && echo "Installing py_doxyqml" && extension --install py_doxyqml && echo "Finished py_doxyqml"
	[ ! -d /usr/lib/python*/site-packages/requests ] && echo "Installing py_requests" && extension --install py_requests && echo "Finished py_requests"
fi

# Additional image formats support in KImageFormats
if [[ $INSTALL_RECOMMENDED != false ]]; then 
	# libavif-1.2.0, libjxl-0.11.1, libraw-0.21.3, libheif, OpenEXR
	[ ! -f /lib/libavif.so ] && echo "Installing libavif" && extension --install libavif && echo "Finished libavif"
	[[ $(command -v jxlinfo) == "" ]] && echo "Installing libjxl" && extension --install libjxl && echo "Finished libjxl"
	[[ $(command -v 4channels) == "" ]] && echo "Installing libraw" && extension --install libraw && echo "Finished libraw"
	#[[ $(command -v libheif) == "" ]] && echo "Installing libheif" && extension --install libheif && echo "Finished libheif"
fi

# Optional dependencies for Solid
if [[ $INSTALL_OPTIONAL != false ]]; then 
	# UDisks-2.10.1, UPower-1.90.7 and media-player-info (runtime)
	[[ $(command -v udisksctl) == "" ]] && echo "Installing udisks" && extension --install udisks && echo "Finished udisks"
	[[ $(command -v upower) == "" ]] && echo "Installing upower" && extension --install upower && echo "Finished upower"
fi

# Optional dependency for KWallet
if [[ $INSTALL_OPTIONAL != false ]]; then 
	# GPGME-1.24.2, built with C++ bindings (which is the default).
	[[ $(command -v gpgme-tool) == "" ]] && echo "Installing gpgme" && extension --install gpgme && echo "Finished gpgme"
fi

# Optional dictionary backends for Sonnet
# Hspell and Hunspell
#if [[ $INSTALL_OPTIONAL != false ]]; then 

if [ $BUILD_ALL == "false" ] && [ ! -f /opt/kf6/bin/kdeinit6 ]; then
	echo "kde_framework _"								>> $EXTENSION/build_order.txt
fi
if [ $BUILD_ALL == "true" ]; then
	echo "kde_framework _"								>> $EXTENSION/build_order.txt
fi
echo "complete _" 										>> $EXTENSION/build_order.txt
