DESCRIPTION="The JSON-C implements a reference counting object model that allows you to easily construct JSON objects in C, output them as JSON formatted strings and parse JSON formatted strings back into the C representation of JSON objects."

EXT_VERSION=$(basename $PKG_JSON_C .tar.gz | cut -d "-" -f 3) 

if [[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]]; then
	sed -i 's/VERSION 2.8/VERSION 4.0/' apps/CMakeLists.txt  &&
	sed -i 's/VERSION 3.9/VERSION 4.0/' tests/CMakeLists.txt
fi

mkdir build
cd    build

cmake -D CMAKE_INSTALL_PREFIX=/usr \
      -D CMAKE_BUILD_TYPE=Release  \
      -D BUILD_STATIC_LIBS=OFF     \
      .. 
make

[[ $(command -v doxygen) != "" ]] && doxygen doc/Doxyfile

# As root:
make install

install -d -vm755 /usr/share/doc/json-c-$EXT_VERSION
install -v -m644 doc/html/* /usr/share/doc/json-c-$EXT_VERSION

update_version_list $PKG_JSON_C
