DESCRIPTION="The jfsutils package contains administration and debugging tools for the jfs file system."

PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_JFS_FS=y) == "CONFIG_JFS_FS=y" ]] && PASS=true
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_JFS_FS=m) == "CONFIG_JFS_FS=m" ]] && PASS=true
[[ $PASS == "false" ]] && echo kernel test failed && exit -1

EXT_VERSION=$(basename $PKG_JFSUTILS .tar.gz | cut -d "-" -f 2) 

[ -f ../$(basename $PATCH_JFSUTILS) ] && patch -Np1 -i ../$(basename $PATCH_JFSUTILS)

sed -i "/unistd.h/a#include <sys/types.h>"    fscklog/extract.c
sed -i "/ioctl.h/a#include <sys/sysmacros.h>" libfs/devices.c

./configure
make

# As root:
make install

update_version_list $PKG_JFSUTILS
