DESCRIPTION="Java is a programming language that works with files of bytecode to obtain instructions and executes them in a Java Virtual Machine (JVM)."

[[ $(uname -m) == "x86_64" ]] && PKG_JAVA=$PKG_JAVA_x64 || PKG_JAVA=$PKG_JAVA_x32

EXT_VERSION_FULL=$(basename $PKG_JAVA .tar.xz | cut -d "-" -f 2) 
EXT_VERSION_PART=$(basename $EXT_VERSION_FULL | cut -d "+" -f 1) 
#echo PWD=$PWD
#echo "tar -xf $(basename $PKG_JAVA)"
tar -xf ../$(basename $PKG_JAVA)
cd $(basename $PKG_JAVA .tar.xz)

# As root:
[ -d /opt/OpenJDK-${EXT_VERSION_PART}-bin ] && rm -r /opt/OpenJDK-${EXT_VERSION_PART}-bin
install -vdm755 /opt/OpenJDK-${EXT_VERSION_PART}-bin
mv -v * /opt/OpenJDK-${EXT_VERSION_PART}-bin
chown -R root:root /opt/OpenJDK-${EXT_VERSION_PART}-bin

[ -h /opt/jdk ] && unlink /opt/jdk
ln -sfn OpenJDK-${EXT_VERSION_PART}-bin /opt/jdk

cd ..
rm -r $(basename $PKG_JAVA .tar.xz)

# Setting up the environment

cat > /etc/profile.d/openjdk.sh << "EOF"
# Begin /etc/profile.d/openjdk.sh

# Set JAVA_HOME directory
JAVA_HOME=/opt/jdk

# Adjust PATH
pathappend $JAVA_HOME/bin

# Auto Java CLASSPATH: Copy jar files to, or create symlinks in, the
# /usr/share/java directory.

AUTO_CLASSPATH_DIR=/usr/share/java

pathprepend . CLASSPATH

for dir in `find ${AUTO_CLASSPATH_DIR} -type d 2>/dev/null`; do
    pathappend $dir CLASSPATH
done

for jar in `find ${AUTO_CLASSPATH_DIR} -name "*.jar" 2>/dev/null`; do
    pathappend $jar CLASSPATH
done

export JAVA_HOME

# By default, Java creates several files in a directory named
# /tmp/hsperfdata_[username]. This directory contains files that are used for
# performance monitoring and profiling, but aren't normally needed on a BLFS
# system. This environment variable disables that feature.
_JAVA_OPTIONS="-XX:-UsePerfData"

export _JAVA_OPTIONS

unset AUTO_CLASSPATH_DIR dir jar _JAVA_OPTIONS

# End /etc/profile.d/openjdk.sh
EOF

cat >> /etc/man_db.conf << "EOF" &&
# Begin Java addition
MANDATORY_MANPATH     /opt/jdk/man
MANPATH_MAP           /opt/jdk/bin     /opt/jdk/man
MANDB_MAP             /opt/jdk/man     /var/cache/man/jdk
# End Java addition
EOF

mkdir -p /var/cache/man &&
mandb -c /opt/jdk/man

[ -h /opt/jdk/lib/security/cacerts ] && unlink /opt/jdk/lib/security/cacerts
ln -sfv /etc/pki/tls/java/cacerts /opt/jdk/lib/security/cacerts

update_version_list java-$EXT_VERSION_FULL
