DESCRIPTION="ImageMagick is a collection of tools and libraries to read, write, and manipulate an image in various image formats."

EXT_VERSION=$(basename $PKG_IMAGEMAGICK .tar.gz | cut -d "-" -f 2 | cut -d "_" -f 1) 

[[ $(command -v fftw-wisdom) != "" ]] && OPTIONS="--with-fftw" | OPTIONS=""
[[ $(command -v rsvg-convert) != "" ]] && OPTIONS="$OPTIONS --with-rsvg"
#[[ $(command -v fftw-wisdom) != "" ]] && OPTIONS="$OPTIONS --with-autotrace"
#[[ $(command -v fftw-wisdom) != "" ]] && OPTIONS="$OPTIONS --with-wmf"
[[ $(command -v gc) != "" ]] && OPTIONS="$OPTIONS --with-gvc"
#[[ $(command -v fftw-wisdom) != "" ]] && OPTIONS="$OPTIONS --with-dejavu-font-dir="

./configure --prefix=/usr     \
            --sysconfdir=/etc \
            --enable-hdri     \
            --with-modules    \
            --with-perl       \
            --disable-static	\
			$OPTIONS
make

# As root:
make DOCUMENTATION_PATH=/usr/share/doc/imagemagick-$EXT_VERSION install

update_version_list $PKG_IMAGEMAGICK
