DESCRIPTION="The International Components for Unicode (ICU) package is a mature, widely used set of C/C++ libraries providing Unicode and Globalization support for software applications."

# Upgrading this package to a new major version (for example, from 72.1 to 77.1) will require rebuilding many other packages. If some packages 
# that use the libraries built by icu4c-77 are rebuilt, they will use the new libraries while current packages will use the previous libraries. 
# If the Linux application loader (/usr/lib/ld-linux-x86-64.so.2) determines that both the old and new libraries are needed, and a symbol (name 
# of data or function) exists in both versions of the library, all references to the symbol will be resolved to the version appearing earlier 
# in the breadth-first sequence of the dependency graph. This may result in the application failing if the definition of the data or the behavior 
# of the function referred by the symbol differs between two versions. To avoid the issue, users will need to rebuild every package linked to an 
# ICU library as soon as possible once ICU is updated to a new major version.

# To determine what external libraries are needed (directly or indirectly) by an application or a library, run:
	# ldd <application or library> 
	
# or to see only programs and libraries that directly use a library:
	# readelf -d  <application or library> | grep NEEDED

EXT_VERSION=$(basename $PKG_ICU -src.tgz | cut -d "-" -f 2 | sed "s/_/./")

cd source

./configure --prefix=/usr
make

# As root:
make install

if $MULTILIB
then
	make clean
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make clean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list icu-$EXT_VERSION
