DESCRIPTION="ibus is an Intelligent Input Bus."

EXT_VERSION=$(basename $PKG_IBUS .tar.gz | cut -d "-" -f 2) 

mkdir -p               /usr/share/unicode/ucd
unzip -o ../$(basename $PKG_UCD) -d /usr/share/unicode/ucd

sed -e 's@/desktop/ibus@/org/freedesktop/ibus@g' \
    -i data/dconf/org.freedesktop.ibus.gschema.xml

if ! [ -e /usr/bin/gtkdocize ]; then
  sed '/docs/d;/GTK_DOC/d' -i Makefile.am configure.ac
fi

[[ $(command -v gtk4-launch) == "" ]] && OPTION="--disable-gtk4" || OPTION=""
[[ $(command -v wayland-scanner) != "" ]] && OPTION="$OPTION --enable-wayland"
[[ $(command -v gtkdocize) != "" ]] && OPTION="$OPTION --enable-gtk-doc"
[[ $(command -v systemctl) == "" ]] && OPTION="$OPTION --disable-systemd-services"

SAVE_DIST_FILES=1 NOCONFIGURE=1 ./autogen.sh

PYTHON=python3                     \
./configure --prefix=/usr          \
            --sysconfdir=/etc      \
            --disable-python2      \
            --disable-appindicator \
            --disable-emoji-dict   \
            --disable-gtk2         \
			--enable-python-library	\
             $OPTION
make

# As root:
make install

gtk-query-immodules-3.0 --update-cache

update_version_list $PKG_IBUS
