DESCRIPTION="The HarfBuzz package contains an OpenType text shaping engine."
# harfBuzz
# The HarfBuzz package contains an OpenType text shaping engine.

# Contents
# Installed Programs: hb-info, hb-ot-shape-closure, hb-shape, hb-subset, and hb-view (only if Cairo is installed)
# Installed Libraries: libharfbuzz.so, libharfbuzz-cairo.so (only if Cairo is installed), libharfbuzz-gobject.so, libharfbuzz-icu.so, and libharfbuzz-subset.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/harbuzz, /usr/lib/cmake/harfbuzz, and /usr/share/gtk-doc/html/harfbuzz (optional)

# Short Descriptions
# hb-info - is used for gathering information about fonts installed on the system
# hb-ot-shape-closure - gives the set of characters contained in a string, represented as single characters and/or single character names. Example: hb-ot-shape-closure /usr/share/fonts/dejavu/DejaVuSans.ttf "Hello World."
# hb-shape - is used for the conversion of text strings into positioned glyphs
# hb-subset - is used to create subsets of fonts, and display text using them
# hb-view - displays a graphical view of a string shape using a particular font as a set of glyphs. The output format is automatically defined by the file extension, the supported ones being ansi/png/svg/pdf/ps/eps. For example: hb-view --output-file=hello.png /usr/share/fonts/dejavu/DejaVuSans.ttf "Hello World."
# libharfbuzz.so - is the HarfBuzz text shaping library
# libharfbuzz-cairo.so - provides Cairo integration for the Harfbuzz text shaping library
# libharfbuzz-gobject.so - provides GObject integration for the HarfBuzz text shaping library
# libharfbuzz-icu.so - provides ICU integration for the HarfBuzz text shaping library
# libharfbuzz-subset.so - provides API functions for performing subsetting operations on font files

# Required
# None

# Recommended
# GLib-2.82.5 (required for Pango; GObject Introspection required for building GNOME), Graphite2-1.3.14 (required for building texlive-20240312 or LibreOffice-25.2.1.2 with system harfbuzz), ICU-76.1, and FreeType-2.13.3 (after harfbuzz is installed, reinstall freetype)

# Recommended_Runtime
# None

# Optional
# Cairo-1.18.2 (circular: build cairo and all its recommended dependencies, including harfbuzz, first, then rebuild harfbuzz if the cairo backend is needed), git-2.48.1, GTK-Doc-1.34.0, FontTools (Python 3 module, for the test suite), ragel, and wasm-micro-runtime

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_HARFBUZZ .tar.xz | cut -d "-" -f 2)

[[ ! $(pkg-config cairo --exists && echo $?) ]] && CAIRO="-D cairo=disabled" || CAIRO="-D cairo=enabled"
[[ ! $(pkg-config graphite2 --exists && echo $?) ]] && GRAPHITE="-D graphite2=disabled" || GRAPHITE="-D graphite2=enabled"

mkdir build
cd    build

meson setup ..				\
      --prefix=/usr			\
      --buildtype=release	\
	  $CAIRO			    \
	  $GRAPHITE				\
      -D tests=disabled
ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	meson setup ..              \
		  --cross-file=lib32    \
		  --prefix=/usr         \
		  --libdir=/usr/lib32   \
		  --buildtype=release   \
		  -D cairo=disabled 	\
		  -D graphite2=disabled	\
		  -D tests=disabled

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig \
	meson setup ..              \
		  --cross-file=libx32   \
		  --prefix=/usr         \
		  --libdir=/usr/libx32  \
		  --buildtype=release   \
		  -D cairo=disabled 	\
		  -D graphite2=disabled	\
		  -D tests=disabled

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	ldconfig	
fi

if [[ $(freetype-config --cflags | grep harfbuzz) == "" ]]; then
	#set +e
	echo "Installing freetype"
	extension --install freetype --rebuild
	echo "Finished freetype"
	#set -e
fi

update_version_list $PKG_HARFBUZZ
