DESCRIPTION="The Guile package contains the GNU Project's extension language library. Guile also contains a stand alone Scheme interpreter."

EXT_VERSION=$(basename $PKG_GUILE .tar.xz | cut -d "-" -f 2) 

if [ -f ../$(basename $PATCH_GUILE) ]; then
	case $(uname -m) in
		i?86) patch -Np1 -i ../$(basename $PATCH_GUILE) ;;
	esac
fi

CC="gcc -std=gnu17"          \
./configure --prefix=/usr    \
            --disable-static \
            --docdir=/usr/share/doc/guile-$EXT_VERSION
make      &&
make html &&

makeinfo --plaintext -o doc/r5rs/r5rs.txt doc/r5rs/r5rs.texi &&
makeinfo --plaintext -o doc/ref/guile.txt doc/ref/guile.texi

# As root:
make install      &&
make install-html &&

mkdir -p                       /usr/share/gdb/auto-load/usr/lib &&
mv /usr/lib/libguile-*-gdb.scm /usr/share/gdb/auto-load/usr/lib &&
mv /usr/share/doc/guile-${EXT_VERSION}/{guile.html,ref} &&
mv /usr/share/doc/guile-${EXT_VERSION}/r5rs{.html,}     &&

find examples -name "Makefile*" -delete         &&
cp -vR examples   /usr/share/doc/guile-$EXT_VERSION

for DIRNAME in r5rs ref; do
  install -v -m644  doc/${DIRNAME}/*.txt \
                    /usr/share/doc/guile-${EXT_VERSION}/${DIRNAME}
done &&
unset DIRNAME

update_version_list $PKG_GUILE
