DESCRIPTION="Gucharmap is a Unicode character map and font viewer."

EXT_VERSION=$(basename $PKG_GUCHARMAP .tar.bz2 | cut -d "-" -f 2) 

mkdir build
cd    build
mkdir ucd
pushd ucd
  unzip ../../../$(basename $PKG_UNICODE)
  cp -v ../../../$(basename $PKG_CJK) .
popd

OPTION=""
[[ $(command -v gtkdocize) != "" ]] && OPTION="-D docs=true" || OPTION="-D docs=false"

meson setup --prefix=/usr       \
            --strip             \
            --buildtype=release \
            -D ucd_path=./ucd   \
            $OPTION ..
ninja

# As root:
rm  -fv /usr/share/glib-2.0/schemas/org.gnome.Charmap.enums.xml
ninja install

update_version_list $PKG_GUCHARMAP
