DESCRIPTION="The GTK3 package contains libraries used for creating graphical user interfaces for applications."
# GTK3
# The GTK3 package contains libraries used for creating graphical user interfaces for applications. 

# Contents
# Installed Programs: broadwayd, gtk3-demo, gtk3-demo-application, gtk3-icon-browser, gtk3-widget-factory, gtk-builder-tool, gtk-encode-symbolic-svg, gtk-launch, gtk-query-immodules-3.0, gtk-query-settings, and gtk-update-icon-cache
# Installed Libraries: libgailutil-3.so, libgdk-3.so, and libgtk-3.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/gtk-3.0, /usr/include/{gail,gtk}-3.0, /usr/{lib,share}/gtk-3.0, and /usr/share/themes/{Default,Emacs}/gtk-3.0

# Short Descriptions
# broadwayd - provides support for displaying GTK3 applications in a web browser, using HTML5 and web sockets
# gtk3-demo - is a simple program that demonstrates some of the tasks that can be done with GTK3
# gtk3-demo-application - is a simple GTK3 application
# gtk3-icon-browser - is a utility to explore the icons in the current icon theme. It shows icons in various sizes, their symbolic variants where available, as well as a description of the icon and its context
# gtk3-widget-factory - is a program to view GTK3 themes and widgets
# gtk-builder-tool - performs various operations on GtkBuilder .ui files
# gtk-encode-symbolic-svg - converts symbolic SVG icons into specially prepared PNG files. GTK3 can load and recolor these PNGs, just like original SVGs, but loading them is much faster
# gtk-launch - launches an application using the given name. The name should match the application desktop file name, as residing in /usr/share/applications, with or without the '.desktop' suffix
# gtk-query-immodules-3.0 - collects information about loadable input method modules for GTK3 and writes it to the default cache file location, or to standard output
# gtk-query-settings - provides a complete listing of all settings related to GTK3
# gtk-update-icon-cache - is an icon theme caching utility that creates mmap()able cache files for icon themes
# libgailutil-3.so - contains functions that implement the accessibility interfaces defined by the GNOME Accessibility Toolkit
# libgdk-3.so - contains functions that act as a wrapper around the low-level drawing and windowing functions provided by the underlying graphics system
# libgtk-3.so - contains functions that provide an API to implement graphical user interfaces

# Required
# at-spi2-core-2.54.1, gdk-pixbuf-2.42.12, libepoxy-1.5.10, and Pango-1.56.1

# Recommended
# adwaita-icon-theme-47.0 (at runtime; default for some gtk3 settings keys and also needed for one test), docbook-xsl-nons-1.79.2 (for generating manual pages), hicolor-icon-theme-0.18 (needed for tests), ISO Codes-4.17.0, libxkbcommon-1.8.0, libxslt-1.1.42 (for generating manual pages), Wayland-1.23.0, and wayland-protocols-1.40

# Recommended_Runtime
# GLib-2.82.5 (with GObject Introspection)

# Optional
# colord-1.4.7, Cups-2.4.11, GTK-Doc-1.34.0, libcloudproviders-0.3.6, PyAtSpi2-2.46.1 (for tests), sassc-3.6.2, tinysparql-3.8.2, and PAPI

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GTK3 .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup ..                 \
      --prefix=/usr            \
      --buildtype=release      \
      -D man=true              \
      -D broadway_backend=true \
	  -D gtk_doc=true			\
	  -D tracker3=true			\
	  -D cloudproviders=true
ninja

# As root:
ninja install

mkdir -vp ~/.config/gtk-3.0
cat > ~/.config/gtk-3.0/settings.ini << "EOF"
[Settings]
gtk-theme-name = Adwaita
gtk-icon-theme-name = oxygen
gtk-font-name = DejaVu Sans 12
gtk-cursor-theme-size = 18
gtk-toolbar-style = GTK_TOOLBAR_BOTH_HORIZ
gtk-xft-antialias = 1
gtk-xft-hinting = 1
gtk-xft-hintstyle = hintslight
gtk-xft-rgba = rgb
gtk-cursor-theme-name = Adwaita
EOF

cat > ~/.config/gtk-3.0/gtk.css << "EOF"
*  {
   -GtkScrollbar-has-backward-stepper: 1;
   -GtkScrollbar-has-forward-stepper: 1;
}
EOF

update_version_list $PKG_GTK3
