DESCRIPTION="gstreamer is a streaming media framework"
# gstreamer
# gstreamer is a streaming media framework that enables applications to share a common set of plugins for tasks such as video encoding and decoding, audio encoding and decoding, audio and video filters, audio visualisation, web streaming and anything else that streams in real-time or otherwise. This package only provides base functionality and libraries. You may need at least gst-plugins-base-1.24.12 and one of Good, Bad, Ugly or Libav plugins. 

# Contents
# Installed Programs: gst-inspect-1.0, gst-launch-1.0, gst-stats-1.0, gst-tester-1.0, and gst-typefind-1.0
# Installed Libraries: libgstbase-1.0.so, libgstcheck-1.0.so, libgstcontroller-1.0.so, libgstnet-1.0.so, and libgstreamer-1.0.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/{include,lib,libexec,share}/gstreamer-1.0

# Short Descriptions
# gst-inspect-1.0 - is a tool that prints out information on available gstreamer plugins, information about a particular plugin, or information about a particular element
# gst-launch-1.0 - is a tool that builds and runs basic gstreamer pipelines
# gst-stats-1.0 - is a tool used to gather statistics about gstreamer operations
# gst-tester-1.0 - runs a test plan in TAP compatible format while integrating with the meson test harness
# gst-typefind-1.0 - uses the gstreamer type finding system to determine the relevant gstreamer plugin to parse or decode files, and the corresponding MIME type
# libgstbase-1.0.so - provides some base classes to be extended by elements and utility classes that are most useful for plugin developers
# libgstcheck-1.0.so - provides functionality for writing unit tests that use the check framework
# libgstcontroller-1.0.so - provides functionality to animate element properties over time
# libgstnet-1.0.so - provides network elements and objects
# libgstreamer-1.0.so - provides all of the core gstreamer services, including initialization, plugin management and types, as well as the object hierarchy that defines elements and bins, along with some more specialized elements

# Required
# GLib-2.82.5 (GObject Introspection required for GNOME)

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# GTK-3.24.48 (for examples), gsl-2.8 (used by one test if installed), libunwind-1.8.1, rustc-1.85.0 (for IEEE 1588:2008 PTP clock support), Valgrind-3.24.0, bash-completion, hotdoc, and libdw

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GSTREAMER .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D gst_debug=false  &&
ninja

# As root:
ninja install

update_version_list $PKG_GSTREAMER
