DESCRIPTION="The GStreamer Base Plug-ins is a well-groomed and well-maintained collection of GStreamer plug-ins and elements"
# gst-plugins-base
# The GStreamer Base Plug-ins is a well-groomed and well-maintained collection of GStreamer plug-ins and elements, spanning the range of possible types of elements one would want to write for GStreamer. You will need at least one of Good, Bad, Ugly or Libav plugins for GStreamer applications to function properly. 

# Contents
# Installed Programs: gst-device-monitor-1.0, gst-discoverer-1.0, and gst-play-1.0
# Installed Libraries: libgstallocators-1.0.so, libgstapp-1.0.so, libgstaudio-1.0.so, libgstfft-1.0.so, libgstgl-1.0.so, libgstpbutils-1.0.so, libgstriff-1.0.so, libgstrtp-1.0.so, libgstrtsp-1.0.so, libgstsdp-1.0.so, libgsttag-1.0.so, libgstvideo-1.0.so, and several plugins under /usr/lib/gstreamer-1.0
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/gstreamer-1.0/gst/{allocators,app,audio,fft,gl,pbutils}, /usr/include/gstreamer-1.0/gst/{riff,rtp,rtsp,sdp,tag,video}, and /usr/share/gst-plugins-base

# Short Descriptions
# gst-device-monitor-1.0 - is a command line tool that can be used to test GStreamer's device monitoring functionality
# gst-discoverer-1.0 - is a tool that can be used to print basic metadata and stream information about a media file
# gst-play-1.0 - is a command line tool that can be used to test basic playback using the playbin element

# Required
# gstreamer-1.24.12

# Recommended
# alsa-lib-1.2.13, CDParanoia-III-10.2 (for building the CDDA plugin), GLib-2.82.5 (with GObject Introspection), ISO Codes-4.17.0, libgudev-238, libjpeg-turbo-3.0.1, libogg-1.3.5, libpng-1.6.46, libvorbis-1.3.7, Mesa-24.3.4, Pango-1.56.1, wayland-protocols-1.40, and Xorg Libraries

# Recommended_Runtime
# None

# Optional
# graphene-1.10.8, GTK-3.24.48 (for examples), Opus-1.5.2, SDL2-2.30.11, Valgrind-3.24.0, hotdoc, libtheora, libvisual, Orc, and Tremor

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GST_PLUGINS_BASE .tar.xz | cut -d "-" -f 4) 

mkdir build
cd    build

meson setup ..               \
      --prefix=/usr          \
      --buildtype=release    \
      --wrap-mode=nodownload
ninja

# As root:
ninja install

update_version_list $PKG_GST_PLUGINS_BASE
