DESCRIPTION="Graphite2 is a rendering engine for graphite fonts."

EXT_VERSION=$(basename $PKG_GRAPHITE2 .tgz  | cut -d "-" -f 2)

# cat > ../graphite2-1.3.14.patch << "EOF"
# diff -ruN graphite2-1.3.14/tests/featuremap/featuremaptest.cpp graphite2/tests/featuremap/featuremaptest.cpp
# --- graphite2-1.3.14/tests/featuremap/featuremaptest.cpp        2020-03-31 22:53:13.000000000 -0400
# +++ graphite2/tests/featuremap/featuremaptest.cpp       2025-09-18 01:11:18.502333352 -0400
# @@ -27,6 +27,7 @@
 # #include <memory>
 # #include <string>
 # #include <vector>
# +#include <cstdint>

 # #include <graphite2/Font.h>

# EOF

# patch -Np1 -i ../graphite2-1.3.14.patch

if [[ $(cmake --version | sed 3d | cut -d " " -f 3 | cut -d "." -f 1) == "4" ]]; then
	sed -i '/cmake_policy(SET CMP0012 NEW)/d' CMakeLists.txt &&
	sed -i 's/PythonInterp/Python3/' CMakeLists.txt          &&
	find . -name CMakeLists.txt | xargs sed -i 's/VERSION 2.8.0 FATAL_ERROR/VERSION 4.0.0/'
fi

if [[ $(gcc --version | cut -d " " -f 3 | sed 2,5d | cut -d "." -f 1) == "15" ]]; then
	sed -i '/Font.h/i #include <cstdint>' tests/featuremap/featuremaptest.cpp
fi

# if [ $BUILD_ALL == "true" ]; then
	# rm /lib/libgraphite2.so
	# rm /lib/libharfbuzz.so
	# BUILD_ALL=false
# fi

# STAGE="0"
# [[ ! -f /lib/libgraphite2.so ]] && STAGE="1"
# [[ -f /lib/libgraphite2.so ]] && [[ ! -f /lib/libharfbuzz.so ]] && STAGE="2"
# [[ -f /lib/libgraphite2.so ]] && [[ -f /lib/libharfbuzz.so ]] && STAGE="3"

# Stage 1, build without harfbuzz
#if [[ $STAGE == "1" ]]; then
if [[ $(command -v hb-info) == "" ]]; then
	#sed -i '/cmptest/d' tests/CMakeLists.txt

	mkdir build
	cd    build

	cmake -D CMAKE_INSTALL_PREFIX=/usr -Wno-dev ..
	make

	#make docs

	# As root:
	make install
	
	cd ..

	# install -v -d -m755 /usr/share/doc/graphite2-$EXT_VERSION &&

	# cp      -v -f    doc/{GTF,manual}.html \
						# /usr/share/doc/graphite2-$EXT_VERSION &&
	# cp      -v -f    doc/{GTF,manual}.pdf \
						# /usr/share/doc/graphite2-$EXT_VERSION
	
	#update_version_list $PKG_GRAPHITE2
	set +e
	echo "Installing harfbuzz"
	extension --install harfbuzz
	echo "Finished harfbuzz"
	set -e
fi

# Step 2 build harfbuzz with graphite2 support
# if [[ $STAGE == "2" ]]; then
	# echo "Installing harfbuzz" && extension --install harfbuzz && echo "Finished harfbuzz"
# fi

# Step 3 rebuild graphite2

make_docs=false
[[ $(command -v  asciidoc ) != "" ]] && [[ $(command -v doxygen) != "" ]] && [[ $(command -v texdoc) != "" ]] && make_docs=true
#echo $make_docs

HB_BUILD=false
[[ $(hb-info --version | grep graphite2) == "" ]] && HB_BUILD=true
#[[ $(command -v comparerender) == "" ]] && HB_BUILD=true # silgraphite
[[ $BUILD_ALL == "true" ]] && HB_BUILD=true

if [[ $HB_BUILD ]]; then
	[ -d build ] && rm -r build
	
	#sed -i '/cmptest/d' tests/CMakeLists.txt

	mkdir build
	cd    build

	cmake -D CMAKE_INSTALL_PREFIX=/usr ..
	make

	[[ $make_docs == true ]] && make docs

	# As root:
	make install

	if [[ $make_docs == true ]]; then
		install -v -d -m755 /usr/share/doc/graphite2-$EXT_VERSION
		cp      -v -f    doc/{GTF,manual}.html /usr/share/doc/graphite2-$EXT_VERSION
		#cp      -v -f    doc/{GTF,manual}.pdf /usr/share/doc/graphite2-$EXT_VERSION
	fi

	update_version_list $PKG_GRAPHITE2
fi

if [[ $(hb-info --version | grep graphite2) == "" ]]; then
	set +e
	echo "Installing harfbuzz"
	extension --install harfbuzz --rebuild
	echo "Finished harfbuzz"
	set -e
fi
